/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.ArrayList;
import org.catacomb.numeric.data.DataItem;
import org.catacomb.numeric.data.NumDataSet;
import org.catacomb.report.E;

public class DataSetArray
extends DataItem {
    NumDataSet first;
    ArrayList<NumDataSet> items = new ArrayList();
    NumDataSet[] bufdsa;

    public DataSetArray() {
        this("error");
    }

    public DataSetArray(String s) {
        super(s);
    }

    public DataSetArray(String s, NumDataSet[] dsa) {
        super(s);
        this.name = s;
        int i = 0;
        while (i < dsa.length) {
            this.items.add(dsa[i]);
            ++i;
        }
    }

    public void add(NumDataSet ds) {
        if (this.first == null) {
            this.first = ds;
        } else if (!this.first.matches(ds)) {
            E.error("mismatched sets in data set array  " + this.first + " " + ds);
        }
        this.bufdsa = null;
        this.items.add(ds);
    }

    public int length() {
        return this.items.size();
    }

    public NumDataSet[] getDataSets() {
        if (this.bufdsa == null) {
            this.bufdsa = this.items.toArray(new NumDataSet[0]);
        }
        return this.bufdsa;
    }

    public NumDataSet firstElement() {
        NumDataSet[] dsa = this.getDataSets();
        return dsa[0];
    }

    public DataSetArray slice(String cond) {
        DataSetArray ret = null;
        if (cond.equals("*")) {
            ret = this;
        } else {
            NumDataSet[] dsa = this.getDataSets();
            int index = 0;
            try {
                index = Integer.parseInt(cond);
            }
            catch (Exception ex) {
                E.error(" cant slice dat aset array with " + cond + " " + ex);
            }
            ret = new DataSetArray();
            ret.add(dsa[index]);
        }
        return ret;
    }

    @Override
    public DataItem getMarked() {
        DataSetArray ret = new DataSetArray(this.getName());
        NumDataSet[] sds = this.getDataSets();
        int i = 0;
        while (i < sds.length) {
            if (sds[i].isMarked()) {
                ret.add(sds[i].copyMarked());
            }
            ++i;
        }
        return ret;
    }
}

