/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.ArrayList;
import java.util.HashMap;
import org.catacomb.datalish.RunDataBlock;
import org.catacomb.datalish.RunDataStore;
import org.catacomb.datalish.SpriteData;
import org.catacomb.datalish.SpriteStore;
import org.catacomb.interlish.structure.DataWatcher;
import org.catacomb.interlish.structure.Named;
import org.catacomb.interlish.structure.Parent;
import org.catacomb.interlish.structure.TreeChangeReporter;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.interlish.structure.TreeRoot;
import org.catacomb.numeric.data.AnimSlice;
import org.catacomb.numeric.data.BlockStack;
import org.catacomb.numeric.data.DVector;
import org.catacomb.numeric.data.EventSequence;
import org.catacomb.numeric.data.NDSAccessor;
import org.catacomb.numeric.data.NumDataItem;
import org.catacomb.numeric.data.NumVector;
import org.catacomb.numeric.data.SimpleSpriteBlock;
import org.catacomb.numeric.data.Timestampable;
import org.catacomb.report.E;

public class NumDataStore
implements RunDataStore,
Named,
TreeRoot,
TreeChangeReporter,
Parent {
    String name;
    ArrayList<Object> children;
    HashMap<String, BlockStack> stackHM;
    HashMap<String, DVector> vecHM;
    HashMap<String, DVector[]> vecArrayHM;
    ArrayList<DVector> dVectors;
    ArrayList<BlockStack> blockStacks;
    ArrayList<EventSequence> evtSequences;
    HashMap<String, EventSequence> evtSeqHM;
    TreeChangeReporter tcReporter;
    ArrayList<DataWatcher> dataWatchers;
    NDSAccessor ndsAccessor;
    SpriteStore spriteStore;
    public double time;
    int nrep = 0;

    public NumDataStore(String s) {
        this.name = s;
        this.stackHM = new HashMap();
        this.vecHM = new HashMap();
        this.vecArrayHM = new HashMap();
        this.dVectors = new ArrayList();
        this.blockStacks = new ArrayList();
        this.evtSequences = new ArrayList();
        this.evtSeqHM = new HashMap();
        this.children = new ArrayList();
        this.dataWatchers = new ArrayList();
        this.spriteStore = new SpriteStore();
        this.ndsAccessor = new NDSAccessor(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setTime(double t) {
        this.time = t;
    }

    public double getTime() {
        return this.time;
    }

    public SpriteStore getSpriteStore() {
        return this.spriteStore;
    }

    public ArrayList<DVector> getDVectors() {
        return this.dVectors;
    }

    public ArrayList<BlockStack> getBlockStacks() {
        return this.blockStacks;
    }

    public ArrayList<EventSequence> getEventSequences() {
        return this.evtSequences;
    }

    public ArrayList<NumVector> getPossibleAbscissae() {
        ArrayList<NumVector> andi = new ArrayList<NumVector>();
        for (Object ch : this.children) {
            NumVector numv;
            if (!(ch instanceof BlockStack) || (numv = ((BlockStack)ch).getFirstArraySlice()) == null) continue;
            andi.add(numv);
        }
        if (this.dVectors != null && this.dVectors.size() > 0) {
            andi.add(this.dVectors.get(0));
        }
        return andi;
    }

    public void add(NumDataItem ndi) {
        if (ndi instanceof EventSequence) {
            this.evtSequences.add((EventSequence)ndi);
            this.children.add(ndi);
            this.evtSeqHM.put(ndi.getName(), (EventSequence)ndi);
            this.reportDataStructureChange();
            this.reportNewChild();
        } else {
            E.error("cant add " + ndi);
        }
    }

    public void addSprite(SpriteData sd) {
        this.spriteStore.add(sd);
    }

    public ArrayList<AnimSlice> getMovies() {
        ArrayList<AnimSlice> msls = new ArrayList<AnimSlice>();
        for (Object ch : this.children) {
            if (!(ch instanceof BlockStack)) continue;
            msls.addAll(((BlockStack)ch).getMovies());
        }
        return msls;
    }

    public void addDataWatcher(DataWatcher dw) {
        ArrayList<DataWatcher> newdw = new ArrayList<DataWatcher>();
        newdw.addAll(this.dataWatchers);
        newdw.add(dw);
        this.dataWatchers = newdw;
    }

    public void removeDataWatcher(DataWatcher dw) {
        ArrayList<DataWatcher> newdw = new ArrayList<DataWatcher>();
        for (DataWatcher odw : this.dataWatchers) {
            if (odw == dw) continue;
            newdw.add(odw);
        }
        this.dataWatchers = newdw;
    }

    public void stack(RunDataBlock se) {
        String s = se.getClass().getName();
        s = s.substring(s.lastIndexOf(".") + 1, s.length());
        this.stack(s, se);
    }

    public void addEvent(String snm, double t, int ich) {
        if (this.evtSeqHM.containsKey(snm)) {
            this.evtSeqHM.get(snm).addEvent(t, ich);
        } else {
            EventSequence es = new EventSequence(snm);
            this.evtSeqHM.put(snm, es);
            this.evtSequences.add(es);
            es.addEvent(t, ich);
            this.reportDataStructureChange();
        }
    }

    public void stack(String snm, double val) {
        if (this.vecHM.containsKey(snm)) {
            this.vecHM.get(snm).add(val);
        } else {
            DVector dvec = new DVector(this, snm);
            this.dVectors.add(dvec);
            dvec.add(val);
            this.vecHM.put(snm, dvec);
            this.children.add(dvec);
            this.reportNewChild();
            this.reportDataStructureChange();
        }
        this.reportDataValueChange();
    }

    public void stack(String snm, double[] val) {
        this.stack(snm, null, val);
    }

    public void stack(String snm, String[] labsin, double[] val) {
        int i;
        String[] labs = labsin;
        DVector[] dva = null;
        if (this.vecArrayHM.containsKey(snm)) {
            dva = this.vecArrayHM.get(snm);
        } else {
            if (labs == null) {
                labs = new String[val.length];
                i = 0;
                while (i < val.length) {
                    labs[i] = "v_" + i;
                    ++i;
                }
            }
            dva = new DVector[labs.length];
            this.vecArrayHM.put(snm, dva);
            i = 0;
            while (i < labs.length) {
                dva[i] = new DVector(this, labs[i]);
                this.children.add(dva[i]);
                this.vecHM.put(labs[i], dva[i]);
                this.dVectors.add(dva[i]);
                ++i;
            }
            E.info("stacked array " + labs.length);
            E.dump(labs);
            this.reportNewChild();
            this.reportDataStructureChange();
        }
        i = 0;
        while (i < dva.length) {
            dva[i].add(val[i]);
            ++i;
        }
        this.reportDataValueChange();
    }

    public void stack(String snm, RunDataBlock str) {
        if (str instanceof Timestampable) {
            ((Timestampable)((Object)str)).stampTime(this.time);
        }
        if (this.stackHM.containsKey(snm)) {
            this.stackHM.get(snm).addToStack(str);
        } else {
            BlockStack ss = new BlockStack(this, snm);
            this.stackHM.put(snm, ss);
            this.blockStacks.add(ss);
            this.children.add(ss);
            ss.setTreeChangeReporter(this);
            ss.addToStack(str);
            this.reportNewChild();
            this.reportDataStructureChange();
        }
        this.reportDataValueChange();
    }

    private void reportNewChild() {
        if (this.tcReporter != null) {
            this.tcReporter.nodeAddedUnder(this, null);
        }
    }

    public NumDataItem getNumDataItem(String s) {
        return this.ndsAccessor.getNumDataItem(s);
    }

    public ArrayList<NumDataItem> getOrdinates(NumVector numV) {
        return this.ndsAccessor.getOrdinates(numV);
    }

    public NumDataItem getSibling(NumVector numV, String snm) {
        return this.ndsAccessor.getSibling(numV, snm);
    }

    public void reportDataValueChange() {
        for (DataWatcher dw : this.dataWatchers) {
            dw.dataValueChanged(this, null);
        }
    }

    public void reportDataStructureChange() {
        for (DataWatcher dw : this.dataWatchers) {
            dw.dataStructureChanged(this, null);
        }
    }

    public void reportCompletion() {
        for (DataWatcher dw : this.dataWatchers) {
            dw.dataComplete(this);
        }
    }

    @Override
    public void nodeAddedUnder(TreeNode parent, TreeNode child) {
        if (this.tcReporter != null) {
            this.tcReporter.nodeAddedUnder(parent, child);
        } else {
            E.error("need tcReporter");
        }
    }

    @Override
    public void nodeRemoved(TreeNode parent, TreeNode child) {
        if (this.tcReporter != null) {
            this.tcReporter.nodeRemoved(parent, child);
        }
    }

    @Override
    public Object getParent() {
        return null;
    }

    @Override
    public TreeNode getRoot() {
        return this;
    }

    @Override
    public int getRootPolicy() {
        return 3;
    }

    @Override
    public void setTreeChangeReporter(TreeChangeReporter tcr) {
        this.tcReporter = tcr;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Object getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.children.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean hasChild(String s) {
        return this.stackHM.containsKey(s) || this.vecHM.containsKey(s) || this.evtSeqHM.containsKey(s);
    }

    @Override
    public Object getChild(String s) {
        Named ret = null;
        if (this.stackHM.containsKey(s)) {
            ret = this.stackHM.get(s);
        } else if (this.vecHM.containsKey(s)) {
            ret = this.vecHM.get(s);
        } else if (this.evtSeqHM.containsKey(s)) {
            ret = this.evtSeqHM.get(s);
        }
        return ret;
    }

    @Override
    public Object[] getObjectPath(String s, boolean b) {
        return this.ndsAccessor.getObjectPath(s).toArray(new Object[0]);
    }

    public void dumpChildren() {
        for (Object obj : this.children) {
            E.info("store child: " + obj);
        }
    }

    public String getPath(Object obj) {
        String pp;
        Object par;
        String ret = null;
        if (obj instanceof Named) {
            ret = ((Named)obj).getName();
        }
        if (obj instanceof TreeNode && (par = ((TreeNode)obj).getParent()) != null && (pp = this.getPath(par)) != null) {
            ret = String.valueOf(pp) + "/" + ret;
        }
        return ret;
    }

    public void spriteAt(String snm, double t, double[] pxy, double[] hxy, double[] wx, double[] wy) {
        this.stack(snm, new SimpleSpriteBlock(t, pxy, hxy, wx, wy));
    }
}

