/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.lang.reflect.Field;
import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.numeric.data.BlockStack;

public abstract class StackSlice
implements TreeNode {
    BlockStack blockStack;
    String fieldName;
    String unit;
    String title;
    Field field;
    BasicTouchTime cacheTime;

    public StackSlice(BlockStack bs, String fnm, Field f, String u, String t) {
        this.blockStack = bs;
        this.fieldName = fnm;
        this.field = f;
        this.unit = u;
        this.title = t;
        this.cacheTime = new BasicTouchTime();
    }

    public String getName() {
        return this.fieldName;
    }

    public String getLabel() {
        return this.title;
    }

    public String toString() {
        return this.fieldName;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getTitle() {
        return this.title;
    }

    public int getNPoint() {
        return this.blockStack.getSize();
    }

    boolean upToDate() {
        return this.cacheTime.isAfter(this.blockStack.getChangeTime());
    }

    public void clear() {
        this.cacheTime.now();
        this.clearCache();
    }

    abstract void clearCache();

    int getSize() {
        return this.blockStack.getSize();
    }

    @Override
    public Object getParent() {
        return this.blockStack;
    }
}

