/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.math;

import org.catacomb.numeric.math.Matrix;
import org.catacomb.report.E;

public final class SMatrix {
    public static double[][] transpose(double[][] a) {
        int nx = a.length;
        int ny = a[0].length;
        double[][] r = new double[ny][nx];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                r[j][i] = a[i][j];
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static double[][] MMmultiply(double[][] a, double[][] b) {
        int nx = a.length;
        int ny = a[0].length;
        int nu = b.length;
        int nv = b[0].length;
        if (ny != nu) {
            E.error("matrix dims incompatible " + nx + " " + ny + "   *   " + ny + " " + nv);
            return null;
        }
        double[][] r = new double[nx][nv];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < nv) {
                int k = 0;
                while (k < ny) {
                    double[] dArray = r[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static double[] MVmultiply(double[][] a, double[] b) {
        int nx = a.length;
        int ny = a[0].length;
        int nu = b.length;
        if (ny != nu) {
            E.error("MVMultiply : matrix dimensions  are incompatible " + nx + " " + ny + "   *   " + ny);
            return null;
        }
        double[] r = new double[nx];
        int i = 0;
        while (i < nx) {
            int k = 0;
            while (k < ny) {
                int n = i;
                r[n] = r[n] + a[i][k] * b[k];
                ++k;
            }
            ++i;
        }
        return r;
    }

    public static double[] LUSolve(double[][] m, double[] R) {
        Matrix M = new Matrix(m);
        M.LU();
        double[] W = M.lubksb(R);
        return W;
    }
}

