/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.mesh;

import org.catacomb.numeric.difnet.NetFactory;
import org.catacomb.numeric.difnet.NetStructure;
import org.catacomb.numeric.difnet.StructureLink;
import org.catacomb.numeric.difnet.StructureNode;
import org.catacomb.numeric.mesh.MeshPoint;

public class MeshNetConverter {
    public static NetStructure meshToNet(MeshPoint[] pts, NetFactory netFactory) {
        MeshPoint mp;
        int nl = 0;
        int i = 0;
        while (i < pts.length) {
            pts[i].setWork(i);
            nl += pts[i].getNeighborCount();
            ++i;
        }
        StructureNode[] nodes = netFactory.newNodeArray(pts.length);
        StructureLink[] links = netFactory.newLinkArray(nl /= 2);
        int i2 = 0;
        while (i2 < pts.length) {
            StructureNode snode;
            mp = pts[i2];
            nodes[i2] = snode = netFactory.newStructureNode();
            snode.setPosition(mp.getX(), mp.getY(), mp.getZ());
            snode.setRadius(mp.getR());
            ++i2;
        }
        nl = 0;
        i2 = 0;
        while (i2 < pts.length) {
            mp = pts[i2];
            int nn = mp.getNeighborCount();
            MeshPoint[] mpn = mp.getNeighbors();
            int j = 0;
            while (j < nn) {
                if (mpn[j].getWork() > i2) {
                    StructureLink slink = netFactory.newStructureLink();
                    slink.setNodeA(nodes[i2]);
                    slink.setNodeB(nodes[mpn[j].getWork()]);
                    links[nl++] = slink;
                }
                ++j;
            }
            ++i2;
        }
        NetStructure netStructure = netFactory.newNetStructure(nodes, links);
        return netStructure;
    }
}

