/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.report;

import java.util.HashSet;
import org.catacomb.report.Reporter;

public class E {
    public static long time0 = 0L;
    static String lastShortSource;
    static String cachedAction;
    static String lastErr;
    static int nrep;
    static String possErrText;
    static HashSet<String> sentMessages;
    static Reporter reporter;
    static final int INFO = 1;
    static final int WARNING = 2;
    static final int ERROR = 3;
    static final int MESSAGE = 4;
    static final int FATAL = 5;
    static final int DEPRECATED = 6;
    static final int MISSING = 7;
    static String[] levels;

    static {
        sentMessages = new HashSet();
    }

    private static void initLevels() {
        levels = new String[10];
        E.levels[1] = "INFO";
        E.levels[2] = "WARNING";
        E.levels[3] = "ERROR";
        E.levels[4] = "MESSAGE";
        E.levels[5] = "FATAL";
        E.levels[6] = "DEPRECATED";
        E.levels[7] = "MISSING";
    }

    public static void setReporter(Reporter r) {
        reporter = r;
    }

    private static long getTime() {
        return System.currentTimeMillis();
    }

    public static void zeroTime() {
        time0 = E.getTime();
    }

    public static String getStringTime() {
        if (time0 == 0L) {
            E.zeroTime();
        }
        long dt = E.getTime() - time0;
        return "" + dt;
    }

    public static void info(String s) {
        E.report(1, String.valueOf(s) + E.getShortSource());
    }

    public static void infoTime(String s) {
        E.report(1, String.valueOf(s) + " at " + E.getStringTime());
    }

    public static void longInfo(String s) {
        E.report(1, s);
        E.showSource(16);
    }

    public static void message(String s) {
        E.report(4, s);
    }

    public static void oneLineWarning(String s) {
        E.report(2, String.valueOf(s) + E.getShortSource());
    }

    public static void shortWarning(String s) {
        E.report(2, String.valueOf(s) + E.getMediumSource());
    }

    public static void shortError(String s) {
        E.report(3, String.valueOf(s) + E.getShortSource());
    }

    public static void medWarning(String s) {
        E.report(2, s);
        E.showSource(4);
    }

    public static void warning(String s) {
        E.report(2, s);
        E.showSource(12);
    }

    public static void linkToWarning(String s, Object obj) {
        E.report(2, s);
        String fcn = obj.getClass().getName();
        String scn = fcn.substring(fcn.lastIndexOf(".") + 1, fcn.length());
        System.out.println("  at " + fcn + ".nomethod(" + scn + ".java:1) " + E.getShortSource());
    }

    public static void error(String s) {
        E.error(s, -1);
    }

    public static void longError(String s) {
        E.error(s, 20);
    }

    public static void error(String s, int n) {
        if (lastErr != null && lastErr.equals(s)) {
            if (++nrep == 3 || nrep == 10 || nrep == 30 || nrep == 100) {
                E.report(3, " .......  last error repeated " + nrep + " times");
            }
        } else {
            if (nrep > 0) {
                E.report(3, "total repeats of last error " + nrep);
            }
            nrep = 0;
            lastErr = s;
            E.report(3, s);
            if (n < 0) {
                E.showSource();
            } else {
                E.showSource(n);
            }
        }
    }

    public static void possibleError(String s) {
        possErrText = "Possible Error " + s + "\n" + E.getMediumSource();
    }

    public static void debugError(String s) {
        E.report(3, s);
        System.out.println("stack trace follows: ");
        E.stackTrace();
    }

    public static void fatalError(String s) {
        E.report(5, s);
        E.stackTrace();
        System.exit(0);
    }

    public static void override(String s) {
        E.report(7, "method should be overridden: " + s);
        E.showSource();
    }

    public static void override() {
        E.report(7, "method should be overridden: ");
        E.showSource();
    }

    public static void deprecate(String s) {
        E.report(6, "using deprecated class: " + s + " " + E.getShortSource());
        E.showShortSource();
    }

    public static void deprecate() {
        E.report(6, "using deprecated method " + E.getShortSource());
        E.showSource();
    }

    public static void missing(String s) {
        E.report(7, "missing code needed: " + s);
        E.showSource();
    }

    public static void missing() {
        E.report(7, "missing code needed");
        E.showSource();
    }

    public static void shortMissing(String s) {
        E.report(7, String.valueOf(s) + E.getShortSource());
    }

    public static void shortMissingOnce(String s) {
        String msg = "MISSING - " + s + E.getShortSource();
        if (!sentMessages.contains(msg)) {
            sentMessages.add(msg);
            E.report(7, String.valueOf(s) + E.getShortSource());
        }
    }

    public static void stackTrace() {
        new Exception().printStackTrace();
    }

    public static void showSource() {
        E.showSource(18);
    }

    public static void showShortSource() {
        E.showSource(2);
    }

    public static void showSource(int n) {
        StackTraceElement[] stea = new Exception().getStackTrace();
        int i = 2;
        while (i < 2 + n && i < stea.length) {
            System.out.println("  at " + stea[i].toString());
            ++i;
        }
    }

    public static String getMediumSource() {
        String ret = "";
        int n = 2;
        StackTraceElement[] stea = new Exception().getStackTrace();
        int i = 2;
        while (i < 2 + n && i < stea.length) {
            ret = String.valueOf(ret) + " at " + stea[i].toString() + "\n";
            ++i;
        }
        return ret;
    }

    public static String getShortSource() {
        StackTraceElement[] stea = new Exception().getStackTrace();
        String ss = " at " + stea[2].toString();
        if (ss.equals(lastShortSource)) {
            ss = "";
        } else {
            lastShortSource = ss;
        }
        return ss;
    }

    public static void delay() {
        E.pause(200);
    }

    public static void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void newLine() {
        System.out.println("...");
    }

    public static void cacheAction(String s) {
        cachedAction = s;
    }

    public static void reportCached() {
        E.report(1, "may relate to: " + cachedAction);
    }

    public static void dump(String[] labs) {
        if (labs != null) {
            int i = 0;
            while (i < labs.length) {
                E.info("element " + i + ": " + labs[i]);
                ++i;
            }
        }
    }

    public static void dump(String s, int[] ia) {
        E.info("int[] array: " + s + " " + ia.length);
        int i = 0;
        while (i < ia.length) {
            E.info("   elt " + i + " = " + ia[i]);
            ++i;
        }
    }

    public static void dump(String s, double[] da) {
        E.info("double[] array: " + s + " " + da.length);
        int i = 0;
        while (i < da.length) {
            E.info("   elt " + i + " = " + da[i]);
            ++i;
        }
    }

    public static String toString(double[] pts) {
        StringBuffer sb = new StringBuffer();
        if (pts == null) {
            sb.append("(null)");
        } else {
            sb.append("[");
            int i = 0;
            while (i < pts.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(String.format("%.3g", new Double(pts[i])));
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static void warnOnce(String msg) {
        if (!sentMessages.contains(msg)) {
            sentMessages.add(msg);
            E.shortWarning(msg);
        }
    }

    public static void report(int level, String s) {
        if (levels == null) {
            E.initLevels();
        }
        System.out.println(String.valueOf(levels[level]) + " - " + s);
        if (reporter != null) {
            if (level == 1) {
                reporter.reportInfo(s);
            } else if (level == 2) {
                reporter.reportWarning(s);
            } else if (level == 3) {
                reporter.reportError(s);
            } else {
                reporter.report(String.valueOf(levels[level]) + "- " + s);
            }
        }
    }
}

