/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.xml;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.catacomb.be.ReReferencable;
import org.catacomb.interlish.report.PrintProgressReport;
import org.catacomb.interlish.structure.Attribute;
import org.catacomb.interlish.structure.Constructor;
import org.catacomb.interlish.structure.ProgressReport;
import org.catacomb.report.E;
import org.catacomb.serial.xml.XMLChecker;
import org.catacomb.serial.xml.XMLHolder;
import org.catacomb.serial.xml.XMLToken;
import org.catacomb.serial.xml.XMLTokenizer;

public class XMLReader {
    ProgressReport progrept;
    Constructor instantiator;
    int sourceLength;
    int nerror;
    double progressFraction;
    String startText;

    public XMLReader(Constructor insta) {
        this.instantiator = insta;
    }

    public void setProgressReport(ProgressReport pr) {
        this.progrept = pr;
    }

    public void err(String s) {
        System.out.println(s);
    }

    public Object readObject(String s) {
        return this.readFromString(s);
    }

    public Object read(String s) {
        return this.readFromString(s);
    }

    public Object readFromString(String sin) {
        String s = sin;
        if ((s = XMLChecker.deGarbage(s)) == null) {
            return null;
        }
        this.startText = s.substring(0, Math.min(200, s.length()));
        this.progressFraction = 0.0;
        this.nerror = 0;
        this.sourceLength = new StringTokenizer(s, "\n").countTokens();
        if (this.progrept != null) {
            this.progrept.setFraction(0.0);
        } else if (this.sourceLength > 10000) {
            this.progrept = new PrintProgressReport();
            this.progrept.setFraction(0.0);
        }
        XMLTokenizer tkz = new XMLTokenizer(s);
        XMLToken xmlt = tkz.nextToken();
        while (xmlt.isIntro() || xmlt.isComment()) {
            xmlt = tkz.nextToken();
        }
        XMLHolder xmlHolder = new XMLHolder();
        this.readFieldIntoParent(tkz, xmlHolder, xmlt);
        return xmlHolder.getContent();
    }

    public XMLToken readToken(XMLTokenizer tkz) {
        double ff;
        XMLToken xmlt = tkz.nextToken();
        int lno = tkz.lineno();
        if (this.nerror > 4) {
            this.err("too many errors - aborting parse at line " + lno);
            xmlt.setType(0);
            if (this.progrept != null) {
                this.progrept.setText("aborted at line " + lno);
            }
        }
        if (this.progrept != null && (ff = (double)lno / ((double)this.sourceLength + 1.0)) > this.progressFraction + 0.005) {
            this.progrept.setFraction(ff);
            this.progressFraction = ff;
        }
        return xmlt;
    }

    public void readFieldIntoParent(XMLTokenizer tkz, Object parent, XMLToken start) {
        if (!start.isOpen()) {
            ++this.nerror;
            this.err("ERROR - read object start item was not an open tag " + start);
            return;
        }
        Object child = null;
        if (parent instanceof String || parent instanceof StringBuffer) {
            child = new StringBuffer();
            ((StringBuffer)child).append(start.getOpenTagString());
        } else {
            Attribute[] atts = start.getAttributes();
            child = this.instantiator.getChildObject(parent, start.getName(), atts);
            if (child != null) {
                this.instantiator.applyAttributes(child, atts);
            }
            if (child == null) {
                child = new ArrayList();
            } else if (child instanceof String) {
                child = new StringBuffer();
            } else if (child.getClass().isArray()) {
                child = new ArrayList();
            }
            if (!start.isClose()) {
                XMLToken next = this.readToken(tkz);
                while (!next.isNone()) {
                    if (next.isOpen()) {
                        this.readFieldIntoParent(tkz, child, next);
                    } else {
                        if (next.isClose()) {
                            if (next.closes(start)) {
                                if (!(parent instanceof String) && !(parent instanceof StringBuffer)) break;
                                ((StringBuffer)child).append(next.getCloseTagString());
                                break;
                            }
                            ++this.nerror;
                            E.shortError(" non-matching close item \nstart Item was: \n" + start.toString() + "\n" + "but close was: \n" + next.toString() + "\n" + "start text was \n" + this.startText);
                            break;
                        }
                        if (next.isString()) {
                            if (child instanceof ArrayList) {
                                E.error("attempted to read string into array list?  - ignored" + next.svalue);
                            } else if (child instanceof StringBuffer) {
                                E.deprecate("xml reader - string added to string buffer " + next.svalue);
                                StringBuffer sbo = (StringBuffer)child;
                                String ssf = sbo.toString();
                                if (ssf.endsWith(">") || next.svalue.startsWith("<") || ssf.length() == 0) {
                                    sbo.append(next.svalue);
                                } else {
                                    sbo.append(" ");
                                    sbo.append(next.svalue);
                                }
                            } else if (child instanceof String && ((String)child).length() > 0) {
                                child = child + " " + next.svalue;
                                E.deprecate("appended string to string " + next.svalue);
                            } else if (child instanceof Double && (Double)child == 0.0) {
                                child = new Double(next.svalue);
                            } else if (child == null) {
                                child = next.svalue;
                            } else {
                                this.instantiator.appendContent(child, next.svalue);
                            }
                        } else if (next.isNumber()) {
                            E.shortError("XMLReader sjhould never return numbers....!!!! but just got " + next);
                        }
                    }
                    next = this.readToken(tkz);
                }
            }
            if (child instanceof StringBuffer) {
                child = ((StringBuffer)child).toString();
            }
            if (child instanceof ReReferencable) {
                ((ReReferencable)child).reReference();
            }
            if (parent instanceof StringBuffer) {
                StringBuffer psb = (StringBuffer)parent;
                psb.append(child);
                psb.append("\n");
            } else if (parent instanceof XMLHolder) {
                ((XMLHolder)parent).setContent(child);
            } else if (parent instanceof ArrayList) {
                E.missing("Array list parent in xmlreader is ignored! - child discarded " + child + " parent=" + parent + " " + start.getName());
                this.setListChild(parent, child);
            } else {
                this.instantiator.setField(parent, start.getName(), child);
            }
        }
    }

    private void setListChild(Object parent, Object child) {
        ((ArrayList)parent).add(child);
    }
}

