/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.PreSaveValidable;
import org.catacomb.interlish.structure.StateQueryable;
import org.catacomb.interlish.structure.Stateless;
import org.catacomb.serial.xml.StringEncoder;
import org.catacomb.serial.xml.XMLElementWriter;

public class XMLWriter {
    boolean conciseTags = false;
    boolean quoteStrings = true;

    public void setConciseTags(boolean b) {
        this.conciseTags = b;
    }

    public void setQuoteStrings(boolean b) {
        this.quoteStrings = b;
    }

    public static void err(String s) {
        System.out.println(s);
    }

    public static XMLWriter newInstance() {
        return new XMLWriter();
    }

    public static String serialize(Object ob) {
        return XMLWriter.getSerialization(ob);
    }

    public static String getSerialization(Object ob) {
        return XMLWriter.newInstance().writeObject(ob);
    }

    public String writeObject(Object obj) {
        StringBuffer sb = new StringBuffer();
        this.appendObject(sb, "", null, obj);
        return sb.toString();
    }

    public void appendObject(StringBuffer sbv, String psk, String knownAs, Object ob) {
        boolean write = true;
        if (ob instanceof String) {
            sbv.append(psk);
            sbv.append("<String>");
            sbv.append(ob);
            sbv.append("</String>\n");
            return;
        }
        if (ob instanceof Stateless) {
            write = false;
        } else if (ob instanceof StateQueryable && !((StateQueryable)ob).hasStateInformation()) {
            write = false;
        }
        if (!write) {
            return;
        }
        if (ob instanceof Element) {
            XMLElementWriter.appendElement(sbv, psk, (Element)ob);
            return;
        }
        if (ob instanceof PreSaveValidable) {
            ((PreSaveValidable)ob).preSaveValidate();
        }
        String tag = "error";
        if (knownAs != null) {
            tag = knownAs;
        } else {
            int ilast;
            tag = ob.getClass().getName();
            if (this.conciseTags && (ilast = tag.lastIndexOf(".")) >= 0) {
                tag = tag.substring(ilast + 1, tag.length());
            }
        }
        sbv.append(psk);
        sbv.append("<" + tag + ">\n");
        String sk = String.valueOf(psk) + "   ";
        Field[] flds = ob.getClass().getFields();
        int i = 0;
        while (i < flds.length) {
            String fieldName = flds[i].getName();
            Object ret = null;
            try {
                ret = flds[i].get(ob);
            }
            catch (Exception e) {
                XMLWriter.err("WARNING - failed to get field " + fieldName + " in  " + ob);
            }
            if (Modifier.isFinal(flds[i].getModifiers())) {
                ret = null;
            }
            if (ret instanceof Double) {
                this.appendNV(sbv, sk, fieldName, (Double)ret);
            } else if (ret instanceof Integer) {
                this.appendNV(sbv, sk, fieldName, (Integer)ret);
            } else if (ret instanceof Boolean) {
                this.appendNV(sbv, sk, fieldName, (Boolean)ret);
            } else if (ret instanceof String) {
                this.appendNV(sbv, sk, fieldName, (String)ret);
            } else if (ret instanceof double[]) {
                this.appendNV(sbv, sk, fieldName, (double[])ret);
            } else if (ret instanceof int[]) {
                this.appendNV(sbv, sk, fieldName, (int[])ret);
            } else if (ret instanceof boolean[]) {
                this.appendNV(sbv, sk, fieldName, (boolean[])ret);
            } else if (ret instanceof String[]) {
                this.appendNV(sbv, sk, fieldName, (String[])ret);
            } else if (ret instanceof double[][]) {
                this.appendNV(sbv, sk, fieldName, (double[][])ret);
            } else if (ret instanceof int[][]) {
                this.appendNV(sbv, sk, fieldName, (int[][])ret);
            } else if (ret != null) {
                this.appendObject(sbv, sk, fieldName, ret);
            }
            ++i;
        }
        if (ob instanceof List) {
            for (Object listobj : (List)ob) {
                this.appendObject(sbv, String.valueOf(psk) + "   ", null, listobj);
            }
        }
        sbv.append(psk);
        sbv.append("</" + tag + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, String value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">");
        this.appendString(sbv, value);
        sbv.append("</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, boolean value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">");
        sbv.append(value ? "1" : "0");
        sbv.append("</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, int value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">");
        sbv.append("" + value);
        sbv.append("</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, double value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">");
        sbv.append("" + value);
        sbv.append("</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, String[] value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">\n");
        int i = 0;
        while (i < value.length) {
            sbv.append(sk);
            sbv.append("   ");
            this.appendString(sbv, value[i] != null ? value[i] : "");
            sbv.append("\n");
            ++i;
        }
        sbv.append(String.valueOf(sk) + "</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, int[] value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">");
        int i = 0;
        while (i < value.length) {
            if (i % 16 == 0) {
                sbv.append("\n" + sk + "   ");
            }
            sbv.append(" " + value[i] + " ");
            ++i;
        }
        sbv.append("\n");
        sbv.append(String.valueOf(sk) + "</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, boolean[] value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">\n" + sk + "  ");
        int i = 0;
        while (i < value.length) {
            sbv.append(" " + (value[i] ? 1 : 0) + " ");
            ++i;
        }
        sbv.append("\n");
        sbv.append(String.valueOf(sk) + "</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, double[] value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">");
        int i = 0;
        while (i < value.length) {
            if (i % 4 == 0) {
                sbv.append("\n" + sk + "   ");
            }
            sbv.append(" " + value[i] + " ");
            ++i;
        }
        sbv.append("\n");
        sbv.append(String.valueOf(sk) + "</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, int[][] value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">\n");
        int i = 0;
        while (i < value.length) {
            sbv.append(sk);
            sbv.append("   <row>");
            int[] ii = value[i];
            int k = 0;
            while (k < ii.length) {
                if (k % 16 == 0) {
                    sbv.append("\n " + sk + "      ");
                }
                sbv.append(" " + ii[k] + " ");
                ++k;
            }
            sbv.append("\n");
            sbv.append(sk);
            sbv.append("   ");
            sbv.append("</row>\n");
            ++i;
        }
        sbv.append(String.valueOf(sk) + "</" + name + ">\n");
    }

    private void appendNV(StringBuffer sbv, String sk, String name, double[][] value) {
        sbv.append(String.valueOf(sk) + "<" + name + ">\n");
        int i = 0;
        while (i < value.length) {
            sbv.append(sk);
            sbv.append("   <row>");
            double[] ii = value[i];
            int k = 0;
            while (k < ii.length) {
                if (k % 4 == 0) {
                    sbv.append("\n " + sk + "      ");
                }
                sbv.append(" " + ii[k] + " ");
                ++k;
            }
            sbv.append("\n");
            sbv.append(sk);
            sbv.append("   ");
            sbv.append("</row>\n");
            ++i;
        }
        sbv.append(String.valueOf(sk) + "</" + name + ">\n");
    }

    private void appendString(StringBuffer sbv, String sssin) {
        String sss = sssin;
        if (sss == null) {
            if (this.quoteStrings) {
                sbv.append("\"null\"");
            } else {
                sbv.append("null");
            }
        } else {
            sss = StringEncoder.xmlEscape(sss);
            if (!this.quoteStrings) {
                sbv.append(sss);
            } else {
                sbv.append("\"");
                sbv.append(sss);
                sbv.append("\"");
            }
        }
    }
}

