/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.catacomb.report.E;
import org.catacomb.util.StringTree;

public class StringUtil {
    public static String readableRegularize(String sin) {
        String s = sin;
        s = s.replaceAll("[\\(\\),;\\./\\\"\\'\\\\\\[\\]]", "");
        s = s.replaceAll("[:&\\.]", "-");
        s = s.replaceAll("[=\\{\\}\\?\\<\\>]", "_");
        s = s.replaceAll("%20", "");
        E.info("string regularization: ");
        E.info("in=" + sin);
        E.info("out=" + s);
        return s;
    }

    public static String regularize(String s) {
        CRC32 crc = new CRC32();
        crc.update(s.getBytes());
        long lval = crc.getValue();
        String sval = "" + lval;
        return sval;
    }

    public static String lastCapitalized(String src) {
        String ret = "";
        Pattern pat = Pattern.compile(".*([A-Z][a-z]+)");
        Matcher matcher = pat.matcher(src);
        if (matcher.find()) {
            ret = matcher.group(1);
        } else {
            E.warning("no capitalized sections in " + src);
        }
        return ret;
    }

    public static void main(String[] argv) {
        String[] sa = new String[]{"cpts.org.eng.misc.thing1", "cpts.org.eng.misc.thing2", "cpts.org.eng.thing3", "cpts.org.neuro.nthing1", "cpts.org.neuro.nthing2", "cpts.org.newneuro.this.that.thingn"};
        StringTree stree = StringUtil.treeify(sa, "tst");
        stree.print();
    }

    public static String[] nonTrivialComponents(String[] sa) {
        ArrayList<String> al = new ArrayList<String>();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && (s = s.trim()).length() > 0) {
                al.add(s);
            }
            ++n2;
        }
        return al.toArray(new String[0]);
    }

    public static StringTree treeify(String[] sa, String rtnm) {
        StringTree root = new StringTree("", rtnm);
        root.setExcluded();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringTokenizer st = new StringTokenizer(s, "\\.");
            root.addFromTokens(st);
            ++n2;
        }
        return root;
    }

    public static StringTree flatTreeify(String[] sa, String rtnm) {
        StringTree root = new StringTree("", rtnm);
        root.setExcluded();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringTokenizer st = new StringTokenizer(s, "\\.");
            root.addFromTokens(st);
            ++n2;
        }
        root.compress();
        root.partialFlatten();
        return root;
    }

    public static String[] copyArray(String[] sa) {
        String[] ret = null;
        if (sa != null) {
            ret = new String[sa.length];
            int i = 0;
            while (i < sa.length) {
                ret[i] = sa[i];
                ++i;
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static String semiHTMLize(String s) {
        if (s == null) {
            return "";
        }
        st = new StringTokenizer(s, "\n");
        ret = new StringBuffer();
        ret.append("<p>\n");
        jdp = false;
        while (st.hasMoreTokens()) {
            sl = st.nextToken();
            if (sl.trim().length() != 0) ** GOTO lbl19
            if (jdp) continue;
            jdp = true;
            ret.append("</p><p>\n");
            continue;
lbl-1000:
            // 1 sources

            {
                ret.append("&nbsp;");
                sl = sl.substring(1, sl.length());
lbl19:
                // 2 sources

                ** while (sl.startsWith((String)" "))
            }
lbl20:
            // 1 sources

            jdp = false;
            ret.append(sl);
            ret.append("<br>\n");
        }
        ret.append("</p>\n");
        return ret.toString();
    }

    public static Double extractQuotedDoubleField(String sin, String fnm) {
        int ike;
        String ks;
        String s = sin;
        Double ret = null;
        int iks = (s = " " + s).indexOf(ks = String.valueOf(fnm) + "=\"");
        if (iks > 0 && (ike = s.indexOf("\"", iks + 1)) > 0) {
            ret = new Double(s.substring(iks + 1, ike));
        }
        E.info("got double field for " + fnm + " from " + s + " as " + ret);
        return ret;
    }

    public static Double extractDoubleField(String sin, String fnm) {
        int ike;
        String ks;
        String s = sin;
        Double ret = null;
        int iks = (s = " " + s + " ").indexOf(ks = String.valueOf(fnm) + "=");
        if (iks > 0 && (ike = s.indexOf(" ", iks + 1)) > 0) {
            ret = new Double(s.substring(iks + ks.length(), ike));
        }
        return ret;
    }

    public static String capitalize(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1, s.length());
    }

    public static final int countLines(String stxt) {
        int lineCount = 0;
        int i = 0;
        while (i < stxt.length()) {
            char ch = stxt.charAt(i);
            if (ch == '\n') {
                ++lineCount;
            }
            ++i;
        }
        return lineCount;
    }
}

