/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.catacomb.util.FileUtil;
import org.textensor.report.E;

public class ResultWriter {
    File outputFile;
    public static final int TEXT = 1;
    public static final int BINARY = 2;
    OutputStreamWriter writer;
    String fnroot = "";
    boolean ready;
    HashMap<String, ResultWriter> siblings;

    public ResultWriter(File outFile) {
        this.outputFile = outFile;
        this.ready = false;
        String fnm = outFile.getName();
        int idot = fnm.lastIndexOf(".");
        this.fnroot = idot > 0 ? fnm.substring(0, idot) : fnm;
    }

    public void init(String magic, int type) {
        if (type == 1) {
            try {
                this.writer = new OutputStreamWriter(new FileOutputStream(this.outputFile));
                if (magic != null) {
                    this.writer.write(String.valueOf(magic) + "\n");
                }
                this.ready = true;
            }
            catch (Exception ex) {
                E.error("cant create file writer " + ex);
            }
        } else {
            E.error("binary not handled yet...");
        }
    }

    public void writeString(String sdat) {
        if (this.ready) {
            try {
                this.writer.write(sdat, 0, sdat.length());
            }
            catch (Exception ex) {
                E.error("cant write: " + ex);
            }
        }
    }

    public void close() {
        if (this.ready) {
            try {
                this.writer.close();
            }
            catch (Exception ex) {
                E.error("ex " + ex);
            }
        } else {
            E.error("data not written (earlier errors)");
        }
        if (this.siblings != null) {
            for (ResultWriter rw : this.siblings.values()) {
                rw.close();
            }
        }
    }

    private ResultWriter getSibling(int type, String extn, String magic) {
        ResultWriter ret = null;
        if (this.siblings == null) {
            this.siblings = new HashMap();
        }
        if (this.siblings.containsKey(extn)) {
            ret = this.siblings.get(extn);
        } else {
            String fnm = String.valueOf(this.fnroot) + extn;
            File f = new File(this.outputFile.getParentFile(), fnm);
            ret = new ResultWriter(f);
            this.siblings.put(extn, ret);
            ret.init(magic, type);
        }
        return ret;
    }

    public void writeToSiblingFileAndClose(String txt, String extn) {
        ResultWriter rw = this.getSibling(1, extn, null);
        rw.writeString(txt);
        rw.close();
    }

    public void writeToSiblingFile(String txt, String extn) {
        this.writeToSiblingFile(txt, extn, null);
    }

    public void writeToSiblingFile(String txt, String extn, String magic) {
        ResultWriter rw = this.getSibling(1, extn, magic);
        rw.writeString(txt);
    }

    public String readSibling(String fnm) {
        String ret = null;
        File fin = new File(this.outputFile.getParentFile(), fnm);
        if (fin.exists()) {
            ret = FileUtil.readStringFromFile(fin);
        } else {
            E.error("No such file " + fin.getAbsolutePath());
        }
        return ret;
    }
}

