/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.inter;

import java.io.File;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.Transitional;
import org.textensor.stochdiff.model.InitialConditions;
import org.textensor.stochdiff.model.ModelBase;
import org.textensor.stochdiff.model.Morphology;
import org.textensor.stochdiff.model.OutputScheme;
import org.textensor.stochdiff.model.ReactionScheme;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.model.StimulationSet;
import org.textensor.stochdiff.neuroml.NeuroMLBase;
import org.textensor.util.FileUtil;
import org.textensor.xml.ReflectionInstantiator;
import org.textensor.xml.XMLReader;

public class ModelReader {
    public static SDRun read(File modelFile) {
        ReflectionInstantiator rin = new ReflectionInstantiator();
        rin.checkAddPackage(new ModelBase());
        rin.checkAddPackage(new NeuroMLBase());
        XMLReader xmlr = new XMLReader(rin);
        SDRun sdm = (SDRun)ModelReader.readFile(modelFile, xmlr);
        File parentFile = modelFile.getParentFile();
        File freact = ModelReader.getFile(parentFile, sdm.reactionSchemeFile);
        File fmorph = ModelReader.getFile(parentFile, sdm.morphologyFile);
        File fstim = ModelReader.getFile(parentFile, sdm.stimulationFile);
        File finitc = ModelReader.getFile(parentFile, sdm.initialConditionsFile);
        File foutput = ModelReader.getFile(parentFile, sdm.outputSchemeFile);
        sdm.setReactionScheme((ReactionScheme)ModelReader.readFile(freact, xmlr));
        Object ob = ModelReader.readFile(fmorph, xmlr);
        if (ob instanceof Transitional) {
            ob = ((Transitional)ob).getFinal();
        }
        sdm.setMorphology((Morphology)ob);
        sdm.setStimulationSet((StimulationSet)ModelReader.readFile(fstim, xmlr));
        sdm.setInitialConditions((InitialConditions)ModelReader.readFile(finitc, xmlr));
        sdm.setOutputScheme((OutputScheme)ModelReader.readFile(foutput, xmlr));
        return sdm;
    }

    private static File getFile(File fparent, String rpath) {
        File ret = new File(fparent, rpath);
        if (!ret.exists() && !(ret = new File(fparent, String.valueOf(rpath) + ".xml")).exists()) {
            E.error("cant find file " + rpath + " in folder " + fparent + " (tried plain and adding .xml)");
        }
        return ret;
    }

    private static Object readFile(File f, XMLReader xmlr) {
        Object ret = null;
        if (f.exists()) {
            String txt = FileUtil.readStringFromFile(f);
            ret = xmlr.read(txt);
        }
        return ret;
    }
}

