/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.inter;

import java.io.File;
import java.util.StringTokenizer;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.SDState;
import org.textensor.util.FileUtil;

public class StateReader {
    public static SDState readState(String fnm) {
        String s = FileUtil.readStringFromFile(new File(fnm));
        return StateReader.readStateString(s);
    }

    public static SDState readStateString(String sdata) {
        String[] bits;
        SDState ret = new SDState();
        boolean readok = true;
        StringTokenizer st = new StringTokenizer(sdata, "\n");
        if (st.hasMoreTokens()) {
            bits = st.nextToken().split(" ");
            ret.nel = Integer.parseInt(bits[1]);
            ret.nspec = Integer.parseInt(bits[2]);
        } else {
            readok = false;
        }
        if (readok) {
            if (st.hasMoreTokens()) {
                bits = st.nextToken().split(" ");
                if (bits.length != ret.nspec) {
                    E.error("wrong length for species lists " + bits.length + " " + ret.nspec);
                    readok = false;
                } else {
                    ret.specids = bits;
                }
            } else {
                readok = false;
            }
        }
        double[][] conc = new double[ret.nel][ret.nspec];
        if (readok) {
            int iel = 0;
            while (iel < ret.nel) {
                if (st.hasMoreTokens()) {
                    String[] bits2 = st.nextToken().split(" ");
                    if (bits2.length == ret.nspec) {
                        int j = 0;
                        while (j < ret.nspec) {
                            conc[iel][j] = Double.parseDouble(bits2[j]);
                            ++j;
                        }
                    }
                } else {
                    readok = false;
                    break;
                }
                ++iel;
            }
        }
        ret.conc = conc;
        if (!readok) {
            E.warning("ignoring initial conditions file");
            ret = null;
        }
        return ret;
    }
}

