/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.chem;

public class StimulationTable {
    int nstim;
    int nspec;
    String[] sites;
    double[][] rates;
    double[] onset;
    double[] duration;
    double[] period;
    double[] ends;

    public StimulationTable() {
        int tableSize = 1000;
        this.sites = new String[tableSize];
        this.rates = new double[tableSize][];
        this.onset = new double[tableSize];
        this.duration = new double[tableSize];
        this.period = new double[tableSize];
        this.ends = new double[tableSize];
    }

    public void addSquarePulse(String injectionSite, double[] vrate, double xonset, double xduration) {
        this.sites[this.nstim] = injectionSite;
        this.rates[this.nstim] = vrate;
        this.onset[this.nstim] = xonset;
        this.duration[this.nstim] = xduration;
        this.period[this.nstim] = -1.0;
        ++this.nstim;
        if (this.nspec <= 0) {
            this.nspec = vrate.length;
        }
    }

    public void addPeriodicSquarePulse(String injectionSite, double[] vrate, double xonset, double xduration, double xperiod, double xend) {
        this.sites[this.nstim] = injectionSite;
        this.sites[this.nstim] = injectionSite;
        this.rates[this.nstim] = vrate;
        this.onset[this.nstim] = xonset;
        this.duration[this.nstim] = xduration;
        this.period[this.nstim] = xperiod;
        this.ends[this.nstim] = xend;
        ++this.nstim;
        if (this.nspec <= 0) {
            this.nspec = vrate.length;
        }
    }

    public double[][] getStimsForInterval(double time, double dt) {
        double[][] ret = new double[this.nstim][this.nspec];
        int i = 0;
        while (i < this.nstim) {
            double f = this.effectiveRate(time, dt, this.onset[i], this.duration[i], this.period[i], this.ends[i]);
            if (f > 0.0) {
                int j = 0;
                while (j < this.nspec) {
                    ret[i][j] = f * this.rates[i][j] * dt;
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    private double effectiveRate(double t, double dt, double ons, double dur, double per, double end) {
        double f = 0.0;
        if (per < 0.0) {
            f = this.pulseOverlap(t, dt, ons, dur);
        } else if (t > end) {
            f = 0.0;
        } else {
            int ipulse = (int)((t - ons) / per + 0.5);
            double pons = ons + (double)ipulse * per;
            f = this.pulseOverlap(t, dt, pons, dur);
        }
        return f;
    }

    private double pulseOverlap(double t, double dt, double ons, double dur) {
        double f = 0.0;
        f = t + dt < ons || t > ons + dur ? 0.0 : (t >= ons && t + dt <= ons + dur ? 1.0 : (t <= ons && t + dt >= ons + dur ? dur / dt : (t <= ons ? (t + dt - ons) / dt : (ons + dur - t) / dt)));
        return f;
    }

    public int getStimIndex(String s) {
        int iret = -1;
        int i = 0;
        while (i < this.nstim) {
            if (this.sites[i].equals(s)) {
                iret = i;
                break;
            }
            ++i;
        }
        return iret;
    }

    public String[] getStimLabels() {
        return this.getTargetIDs();
    }

    public int getNStim() {
        return this.nstim;
    }

    public String[] getTargetIDs() {
        String[] ret = new String[this.nstim];
        int i = 0;
        while (i < this.nstim) {
            ret[i] = this.sites[i];
            ++i;
        }
        return ret;
    }
}

