/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.grid;

import org.textensor.report.E;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.BaseCalc;
import org.textensor.stochdiff.numeric.chem.ReactionTable;
import org.textensor.stochdiff.numeric.chem.StimulationTable;
import org.textensor.stochdiff.numeric.math.Column;
import org.textensor.stochdiff.numeric.math.Matrix;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;

public class DeterministicGridCalc
extends BaseCalc {
    static final double NM_PER_PARTICLE_PUV = 1.6605778811026237;
    static final double PARTICLES_PUVC = 0.6022;
    Column mconc;
    ReactionTable rtab;
    VolumeGrid vgrid;
    StimulationTable stimTab;
    double dt;
    int nel;
    int nspec;
    String[] specieIDs;
    double[] volumes;
    double[] fdiff;
    boolean[] submembranes;
    String[] regionLabels;
    int[][] neighbors;
    double[][] couplingConstants;
    int[][] stimtargets;
    int[] eltstims;
    double[] eltstimshare;
    int[] eltregions;
    double[] surfaceAreas;
    double[][] wkA;
    double[][] wkB;
    double[][] wkC;
    int nlog;
    double stateSaveTime;

    public DeterministicGridCalc(SDRun sdm) {
        super(sdm);
    }

    public final void init() {
        double[][] cc;
        this.stateSaveTime = this.sdRun.getStateSaveInterval();
        if (this.stateSaveTime <= 0.0) {
            this.stateSaveTime = 1.0E9;
        }
        this.rtab = this.getReactionTable();
        this.vgrid = this.getVolumeGrid();
        this.nel = this.vgrid.getNElements();
        this.nspec = this.rtab.getNSpecies();
        this.specieIDs = this.rtab.getSpecieIDs();
        this.volumes = this.vgrid.getElementVolumes();
        this.fdiff = this.rtab.getDiffusionConstants();
        this.neighbors = this.vgrid.getPerElementNeighbors();
        this.couplingConstants = this.vgrid.getPerElementCouplingConstants();
        this.extractOutputScheme(this.rtab);
        this.submembranes = this.vgrid.getSubmembranes();
        this.regionLabels = this.vgrid.getRegionLabels();
        this.stimTab = this.getStimulationTable();
        this.stimtargets = this.vgrid.getAreaIndexes(this.stimTab.getTargetIDs());
        this.eltstims = new int[this.nel];
        this.eltstimshare = new double[this.nel];
        int i = 0;
        while (i < this.eltstims.length) {
            this.eltstims[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.stimtargets.length) {
            int[] asti = this.stimtargets[i];
            double vtot = 0.0;
            int k = 0;
            while (k < asti.length) {
                vtot += this.volumes[asti[k]];
                ++k;
            }
            k = 0;
            while (k < asti.length) {
                this.eltstims[asti[k]] = i;
                this.eltstimshare[asti[k]] = this.volumes[i] / vtot;
                ++k;
            }
            ++i;
        }
        this.eltregions = this.vgrid.getRegionIndexes();
        this.surfaceAreas = this.vgrid.getExposedAreas();
        this.wkA = new double[this.nel][this.nspec];
        this.wkB = new double[this.nel][this.nspec];
        this.wkC = new double[this.nel][this.nspec];
        this.dt = this.sdRun.fixedStepDt;
        double[][] regcon = this.getRegionConcentrations();
        double[][] regsd = this.getRegionSurfaceDensities();
        int i2 = 0;
        while (i2 < this.nel) {
            double[] rcs = regcon[this.eltregions[i2]];
            int j = 0;
            while (j < this.nspec) {
                this.wkA[i2][j] = rcs[j];
                this.wkB[i2][j] = rcs[j];
                this.wkC[i2][j] = rcs[j];
                ++j;
            }
            double a = this.surfaceAreas[i2];
            double[] scs = regsd[this.eltregions[i2]];
            if (a > 0.0 && scs != null) {
                double concfac = a / this.volumes[i2];
                int j2 = 0;
                while (j2 < this.nspec) {
                    if (!Double.isNaN(scs[j2])) {
                        this.wkA[i2][j2] = concfac * scs[j2];
                        this.wkB[i2][j2] = concfac * scs[j2];
                        this.wkC[i2][j2] = concfac * scs[j2];
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        if (this.sdRun.initialStateFile != null && (cc = this.readInitialState(this.sdRun.initialStateFile, this.nel, this.nspec, this.specieIDs)) != null) {
            int i3 = 0;
            while (i3 < this.nel) {
                int j = 0;
                while (j < this.nspec) {
                    double c;
                    this.wkA[i3][j] = c = cc[i3][j];
                    this.wkB[i3][j] = c;
                    ++j;
                }
                ++i3;
            }
        }
    }

    private String getGridConcsText(double time) {
        StringBuffer sb = new StringBuffer();
        int nspecout = this.ispecout.length;
        if (nspecout == 0) {
            return "";
        }
        sb.append("gridConcentrations " + this.nel + " " + nspecout + " " + time + " ");
        int i = 0;
        while (i < nspecout) {
            sb.append(String.valueOf(this.specieIDs[this.ispecout[i]]) + " ");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < nspecout) {
                if (this.writeConcentration) {
                    sb.append(this.stringd(this.wkA[i][this.ispecout[j]]));
                } else {
                    sb.append(this.stringd(this.wkA[i][this.ispecout[j]] * this.volumes[i] * 0.6022));
                }
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private String getGridConcsPlainText_dumb(int filenum, double time) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.stringd(time));
        int j = 0;
        while (j < this.specIndexesOut[filenum].length) {
            int i = 0;
            while (i < this.nel) {
                if (this.regionsOut[filenum].equals("default") || this.regionsOut[filenum].equals(this.regionLabels[this.eltregions[i]])) {
                    double wkv = this.wkA[i][this.specIndexesOut[filenum][j]];
                    if (this.writeConcentration) {
                        sb.append(this.stringd(wkv));
                    } else {
                        sb.append(this.stringd(0.6022 * wkv * this.volumes[i]));
                    }
                }
                ++i;
            }
            ++j;
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getStateText() {
        StringBuffer sb = new StringBuffer();
        sb.append("nrds " + this.nel + " " + this.specieIDs.length + "\n");
        int i = 0;
        while (i < this.specieIDs.length) {
            sb.append(String.valueOf(this.specieIDs[i]) + " ");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.specieIDs.length) {
                sb.append(this.stringd(this.wkA[i][j]));
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public final void run() {
        this.init();
        if (this.resultWriter != null) {
            this.resultWriter.writeString(this.vgrid.getAsText());
            this.resultWriter.writeToSiblingFileAndClose(this.vgrid.getAsTableText(), "-mesh.txt");
            int i = 0;
            while (i < this.fnmsOut.length) {
                this.resultWriter.writeToSiblingFile(this.getGridConcsHeadings_dumb(i), "-" + this.fnmsOut[i] + "-conc.txt");
                ++i;
            }
        }
        double time = 0.0;
        double runtime = this.sdRun.runtime;
        double tlog = 5.0;
        long startTime = System.currentTimeMillis();
        double writeTime = -1.0E-9;
        double[] writeTimeArray = new double[this.fnmsOut.length];
        int i = 0;
        while (i < this.fnmsOut.length) {
            writeTimeArray[i] = -1.0E-9;
            ++i;
        }
        boolean iwr = false;
        while (time < runtime) {
            if (time >= writeTime) {
                if (this.resultWriter != null) {
                    this.resultWriter.writeString(this.getGridConcsText(time));
                }
                writeTime += this.sdRun.outputInterval;
            }
            int i2 = 0;
            while (i2 < this.fnmsOut.length) {
                if (time >= writeTimeArray[i2]) {
                    this.resultWriter.writeToSiblingFile(this.getGridConcsPlainText_dumb(i2, time), "-" + this.fnmsOut[i2] + "-conc.txt");
                    int n = i2;
                    writeTimeArray[n] = writeTimeArray[n] + Double.valueOf(this.dtsOut[i2]);
                }
                ++i2;
            }
            if ((time += this.advance(time)) > tlog) {
                E.info("time " + time + " dt=" + this.dt);
                tlog += Math.max(50.0 * this.sdRun.outputInterval, 5.0);
            }
            if (!(time >= this.stateSaveTime)) continue;
            this.resultWriter.writeToSiblingFile(this.getStateText(), String.valueOf(this.sdRun.stateSavePrefix) + "-" + Math.round(time) + ".nrds");
            this.stateSaveTime += this.sdRun.getStateSaveInterval();
        }
        long endTime = System.currentTimeMillis();
        E.info("total time " + (endTime - startTime) + "ms");
    }

    public double advance(double time) {
        int i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.nspec) {
                this.wkC[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        double[] zl = new double[this.nspec];
        double[] zr = new double[this.nspec];
        int iel = 0;
        while (iel < this.nel) {
            double vol = this.volumes[iel];
            double fvol = 2.0 * this.dt / vol;
            int k = 0;
            while (k < this.nspec) {
                zr[k] = this.wkC[iel][k] / vol;
                zl[k] = 1.0;
                ++k;
            }
            int[] inbr = this.neighbors[iel];
            double[] gnbr = this.couplingConstants[iel];
            int nnbr = inbr.length;
            int j = 0;
            while (j < nnbr) {
                int k2 = 0;
                while (k2 < this.nspec) {
                    double ff = fvol * this.fdiff[k2] * gnbr[j];
                    int n = k2;
                    zr[n] = zr[n] + ff * (this.wkB[inbr[j]][k2] - 0.5 * this.wkA[iel][k2]);
                    int n2 = k2++;
                    zl[n2] = zl[n2] + 0.5 * ff;
                }
                ++j;
            }
            int k3 = 0;
            while (k3 < this.nspec) {
                this.wkC[iel][k3] = (this.wkA[iel][k3] + zr[k3]) / zl[k3];
                ++k3;
            }
            ++iel;
        }
        double[][] stims = this.stimTab.getStimsForInterval(time, this.dt);
        int iel2 = 0;
        while (iel2 < this.nel) {
            if (this.eltstims[iel2] >= 0) {
                double[] pinj = stims[this.eltstims[iel2]];
                double[] concinc = new double[pinj.length];
                double fconc = 1.6605778811026237 / this.volumes[iel2];
                int i2 = 0;
                while (i2 < pinj.length) {
                    concinc[i2] = pinj[i2] * fconc * this.eltstimshare[iel2];
                    if (concinc[i2] < 0.0) {
                        E.error("negative concentration? " + concinc[i2]);
                    }
                    ++i2;
                }
                this.reacStep(this.wkC[iel2], this.dt, concinc);
            } else {
                this.reacStep(this.wkC[iel2], this.dt, null);
            }
            ++iel2;
        }
        double[][] wkT = this.wkA;
        this.wkA = this.wkB;
        this.wkB = this.wkC;
        this.wkC = wkT;
        return this.dt;
    }

    private void reacStep(double[] concs, double deltat, double[] concinc) {
        Column col = new Column(concs);
        Matrix m = this.rtab.getIncrementRateMatrix(col);
        Column cp = this.rtab.getProductionColumn(col);
        Column cpdt = cp.times(deltat);
        m.multiplyBy(this.dt);
        m.subtractIdentity();
        m.negate();
        if (concinc != null) {
            cpdt.incrementBy(concinc);
        }
        Column dc = m.LUSolve(cpdt);
        col.incrementBy(dc);
        col.writeTo(concs);
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }

    protected String getGridConcsHeadings_dumb(int filenum) {
        StringBuffer sb = new StringBuffer();
        sb.append("time");
        int j = 0;
        while (j < this.specIndexesOut[filenum].length) {
            int i = 0;
            while (i < this.nel) {
                if (this.regionsOut[filenum].equals("default") || this.regionsOut[filenum].equals(this.regionLabels[this.eltregions[i]])) {
                    sb.append(" Vol_" + i);
                    sb.append("_" + this.regionLabels[this.eltregions[i]]);
                    String tempLabel = this.vgrid.getLabel(i);
                    if (this.vgrid.getGroupID(i) != null) {
                        sb.append("." + this.vgrid.getGroupID(i));
                    } else if (tempLabel != null && tempLabel.indexOf(".") > 0) {
                        sb.append("." + tempLabel.substring(0, tempLabel.indexOf(".")));
                    }
                    if (this.submembranes[i]) {
                        sb.append("_submembrane");
                    } else {
                        sb.append("_cytosol");
                    }
                    if (tempLabel != null) {
                        if (tempLabel.indexOf(".") > 0) {
                            sb.append("_" + tempLabel.substring(tempLabel.indexOf(".") + 1, tempLabel.length()));
                        } else {
                            sb.append("_" + this.vgrid.getLabel(i));
                        }
                    }
                    sb.append("_Spc_" + this.specieIDs[this.specIndexesOut[filenum][j]]);
                }
                ++i;
            }
            ++j;
        }
        sb.append("\n");
        return sb.toString();
    }
}

