/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.morph;

import java.util.ArrayList;
import org.textensor.report.E;
import org.textensor.stochdiff.geom.GRotation;
import org.textensor.stochdiff.geom.Geom;
import org.textensor.stochdiff.geom.Position;
import org.textensor.stochdiff.geom.Translation;
import org.textensor.stochdiff.geom.Vector;
import org.textensor.stochdiff.numeric.morph.TreePoint;
import org.textensor.stochdiff.numeric.morph.VolumeElement;

public class VolumeLine {
    int nl;
    double lSize;
    double depth;
    VolumeElement[][] elements;

    public VolumeLine(int n, double w, double d) {
        this.nl = n;
        this.lSize = w;
        this.depth = d;
    }

    public VolumeElement getElement(int i) {
        return this.elements[i][0];
    }

    public void lineFill(Position pa, Position pb, String pointLabel, String regionLabel) {
        double sl = Geom.distanceBetween(pa, pb);
        Translation trans = Geom.translation(Geom.midpoint(pa, pb));
        Vector vab = Geom.fromToVector(pa, pb);
        double theta = Geom.zRotationAngle(Geom.unitY(), vab);
        GRotation rot = Geom.aboutZRotation(theta);
        this.elements = new VolumeElement[this.nl][1];
        double dl = this.lSize / (double)this.nl;
        int i = 0;
        while (i < this.nl) {
            double vcl = -0.5 * this.lSize + ((double)i + 0.5) * dl;
            VolumeElement ve = new VolumeElement();
            ve.setAlongArea(this.depth * sl);
            ve.setSideArea(this.depth * dl);
            Position cp = Geom.position(vcl, 0.0, 0.0);
            Position pr = rot.getRotatedPosition(cp);
            Position pc = trans.getTranslated(pr);
            ve.setCenterPosition(pc.getX(), pc.getY(), pc.getZ());
            if (i == 0 || i == this.nl - 1) {
                ve.setSubmembrane();
            }
            Position[] pbdry = new Position[]{Geom.position(vcl - 0.5 * dl, -0.5 * sl, 0.0), Geom.position(vcl - 0.5 * dl, 0.5 * sl, 0.0), Geom.position(vcl + 0.5 * dl, 0.5 * sl, 0.0), Geom.position(vcl + 0.5 * dl, -0.5 * sl, 0.0)};
            int ib = 0;
            while (ib < pbdry.length) {
                pbdry[ib] = trans.getTranslated(rot.getRotatedPosition(pbdry[ib]));
                ++ib;
            }
            ve.setBoundary(pbdry);
            if (regionLabel != null) {
                ve.setRegion(regionLabel);
            }
            if (i == 0 || i == this.nl - 1) {
                double xb;
                Position[] psb = new Position[4];
                if (i == 0) {
                    xb = vcl - 0.5 * dl;
                    psb[0] = Geom.position(xb, -0.5 * sl, -0.5 * this.depth);
                    psb[1] = Geom.position(xb, -0.5 * sl, 0.5 * this.depth);
                    psb[2] = Geom.position(xb, 0.5 * sl, 0.5 * this.depth);
                    psb[3] = Geom.position(xb, 0.5 * sl, -0.5 * this.depth);
                } else {
                    xb = vcl + 0.5 * dl;
                    psb[0] = Geom.position(xb, -0.5 * sl, -0.5 * this.depth);
                    psb[1] = Geom.position(xb, 0.5 * sl, -0.5 * this.depth);
                    psb[2] = Geom.position(xb, 0.5 * sl, 0.5 * this.depth);
                    psb[3] = Geom.position(xb, -0.5 * sl, 0.5 * this.depth);
                }
                int ib2 = 0;
                while (ib2 < psb.length) {
                    psb[ib2] = trans.getTranslated(rot.getRotatedPosition(psb[ib2]));
                    ++ib2;
                }
                ve.setSurfaceBoundary(psb);
                ve.setExposedArea(sl * this.depth);
            }
            ve.setVolume(dl * sl * this.depth);
            ve.setDeltaZ(this.depth);
            this.elements[i][0] = ve;
            ++i;
        }
        if (pointLabel != null) {
            this.elements[this.nl / 2][0].setLabel(pointLabel);
        }
        this.neighborize();
    }

    public void neighborize() {
        int i = 0;
        while (i < this.nl) {
            VolumeElement v = this.elements[i][0];
            VolumeElement vx = null;
            if (i + 1 < this.nl) {
                vx = this.elements[i + 1][0];
            }
            if (v != null && vx != null) {
                v.coupleTo(vx, v.getAlongArea());
            }
            ++i;
        }
    }

    public void planeConnect(VolumeLine tgt) {
        if (tgt.nl == this.nl) {
            int i = 0;
            while (i < this.nl) {
                VolumeElement va = this.getElement(i);
                VolumeElement vb = tgt.getElement(i);
                if (va != null && vb != null) {
                    va.coupleTo(vb, va.getSideArea());
                }
                ++i;
            }
        } else if (this.lSize / (double)this.nl <= tgt.lSize / (double)tgt.nl) {
            this.smallBigMatchConnect(tgt);
        } else {
            tgt.smallBigMatchConnect(this);
        }
    }

    public void subPlaneConnect(TreePoint tp, TreePoint tpl, VolumeLine tgt, double offset) {
        E.info("segment junction: " + this.nl + " points across " + this.lSize + " being connected to " + tgt.nl + " across " + tgt.lSize);
        double[][] rngme = this.makeRanges(this.lSize, this.nl);
        double[][] rngtgt = this.makeRanges(tgt.lSize, tgt.nl);
        double offeff = -1.0 * (offset - 0.5 * (this.lSize - tgt.lSize));
        E.info("shifting child branch " + offeff + " relative to parent center");
        int i = 0;
        while (i < rngtgt.length) {
            double[] dArray = rngtgt[i];
            dArray[0] = dArray[0] + offeff;
            double[] dArray2 = rngtgt[i];
            dArray2[1] = dArray2[1] + offeff;
            ++i;
        }
        i = 0;
        while (i < tgt.nl) {
            VolumeElement vtgt = tgt.getElement(i);
            int jme = 0;
            while (jme < this.nl) {
                double fol = this.overlapFactor(rngme[jme], rngtgt[i]);
                if (fol > 0.001) {
                    VolumeElement vme = this.getElement(jme);
                    vme.coupleTo(vtgt, fol * vme.getSideArea());
                    E.info("coupled parent element " + jme + " to child element " + i + " overlap factor = " + fol);
                }
                ++jme;
            }
            ++i;
        }
    }

    private void smallBigMatchConnect(VolumeLine tgt) {
        double[][] rngme = this.makeRanges(this.lSize, this.nl);
        double[][] rngtgt = this.makeRanges(tgt.lSize, tgt.nl);
        int i = 0;
        while (i < this.nl) {
            double fol2;
            VolumeElement va = this.getElement(i);
            int ifol = this.getFirstOverlap(rngme[i], rngtgt);
            double fol1 = this.overlapFactor(rngme[i], rngtgt[ifol]);
            if (fol1 > 0.001) {
                VolumeElement vb = tgt.getElement(ifol);
                va.coupleTo(vb, fol1 * va.getSideArea());
            }
            if (ifol < rngtgt.length - 1 && (fol2 = this.overlapFactor(rngme[i], rngtgt[ifol + 1])) > 0.001) {
                VolumeElement vb = tgt.getElement(ifol + 1);
                va.coupleTo(vb, fol2 * va.getSideArea());
            }
            ++i;
        }
    }

    public int getFirstOverlap(double[] rng, double[][] tgts) {
        int iol = 0;
        while (iol < tgts.length - 1 && (rng[1] <= tgts[iol][0] || rng[0] >= tgts[iol][1])) {
            ++iol;
        }
        return iol;
    }

    private double overlapFactor(double[] rng, double[] tgt) {
        double dr = rng[1] - rng[0];
        double ret = 0.0;
        if (rng[0] >= tgt[0] && rng[1] <= tgt[1]) {
            ret = dr;
        } else if (rng[1] <= tgt[0] || rng[0] >= tgt[1]) {
            ret = 0.0;
        } else if (rng[1] < tgt[1]) {
            ret = rng[1] - tgt[0];
        } else if (rng[1] >= tgt[1]) {
            ret = rng[0] < tgt[0] ? tgt[1] - tgt[0] : tgt[1] - rng[0];
        }
        return ret /= dr;
    }

    private double[][] makeRanges(double ltot, int nreg) {
        double[][] ret = new double[nreg][2];
        double dl = ltot / (double)nreg;
        int i = 0;
        while (i < nreg) {
            double rl;
            ret[i][0] = rl = -0.5 * ltot + (double)i * dl;
            ret[i][1] = rl + dl;
            ++i;
        }
        return ret;
    }

    public ArrayList<VolumeElement> getElements() {
        ArrayList<VolumeElement> ave = new ArrayList<VolumeElement>();
        int i = 0;
        while (i < this.nl) {
            VolumeElement ve = this.getElement(i);
            if (ve != null) {
                ave.add(ve);
            }
            ++i;
        }
        return ave;
    }
}

