/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.pool;

import org.textensor.report.E;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.math.Column;
import org.textensor.stochdiff.numeric.math.Matrix;
import org.textensor.stochdiff.numeric.pool.DeterministicPoolCalc;

public class ImplicitEulerPoolCalc
extends DeterministicPoolCalc {
    int maxIterationsSoFar;

    public ImplicitEulerPoolCalc(SDRun sdm) {
        super(sdm);
    }

    @Override
    public void dpcInit() {
        this.maxIterationsSoFar = 0;
    }

    @Override
    public double advance() {
        double tol = 1.0E-7;
        Column c = this.mconc;
        Column dc = new Column(c.size());
        int iit = 0;
        double erhs = 0.0;
        do {
            Column rhs = this.rtab.stepResiduals(c, dc, this.dt);
            erhs = rhs.avgAbs();
            ++iit;
            if (erhs > tol) {
                if (iit > this.maxIterationsSoFar) {
                    this.maxIterationsSoFar = iit;
                }
                Matrix m = this.numderivs(c, dc, this.dt);
                Column w = m.LUSolve(rhs);
                dc.decrementBy(w);
            }
            if (iit <= 12) continue;
            E.error(" failed to converge");
            break;
        } while (erhs > 1.0E-7);
        this.mconc.incrementBy(dc);
        return this.dt;
    }

    private final Matrix numderivs(Column vc, Column vdc, double deltat) {
        int n = this.rtab.nspecie;
        Matrix m = new Matrix(n);
        double[] r0 = this.rtab.stepResiduals(vc, vdc, deltat).getData();
        double delta = 1.0E-6;
        int j = 0;
        while (j < n) {
            Column vdelta = vdc.copy();
            vdelta.increment(j, delta);
            double[] rd = this.rtab.stepResiduals(vc, vdelta, deltat).getData();
            int i = 0;
            while (i < n) {
                m.set(i, j, (rd[i] - r0[i]) / delta);
                ++i;
            }
            ++j;
        }
        return m;
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }
}

