/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.stochastic;

import org.textensor.stochdiff.numeric.stochastic.ProbabilityTable;

public class BinomialTable
extends ProbabilityTable {
    private static final int NMAX = 140;
    private static BinomialTable instance;
    private double[][] ncmtbl = new double[140][];

    public static BinomialTable getTable() {
        if (instance == null) {
            instance = new BinomialTable();
        }
        return instance;
    }

    private BinomialTable() {
        this.ncmtbl[0] = new double[0];
        this.ncmtbl[1] = new double[1];
        this.ncmtbl[1][0] = 1.0;
        int i = 2;
        while (i < 140) {
            int nel = i / 2 + 1;
            double[] row = new double[nel];
            double[] abv = this.ncmtbl[i - 1];
            row[0] = 1.0;
            int j = 1;
            while (j < nel) {
                row[j] = abv[j - 1] + (j < abv.length ? abv[j] : abv[j - 1]);
                ++j;
            }
            this.ncmtbl[i] = row;
            ++i;
        }
    }

    public double ncm(int n, int m) {
        double ret = 0.0;
        ret = m > n - m ? this.ncmtbl[n][n - m] : this.ncmtbl[n][m];
        return ret;
    }

    public void print(int n) {
        int i = 0;
        while (i < n) {
            StringBuffer sb = new StringBuffer();
            sb.append("row " + i + "  ");
            double[] c = this.ncmtbl[i];
            int j = 0;
            while (j < c.length) {
                sb.append(c[j]);
                sb.append(" ");
                ++j;
            }
            System.out.println(sb);
            ++i;
        }
    }

    public static void main(String[] argv) {
        BinomialTable btbl = BinomialTable.getTable();
        btbl.print(20);
    }
}

