/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.stochastic;

import java.util.Random;
import org.textensor.stochdiff.numeric.math.MersenneTwister;
import org.textensor.stochdiff.numeric.math.NRRandom;
import org.textensor.stochdiff.numeric.stochastic.InterpolatingStepGenerator;

public class TimeTests {
    public static void main(String[] argv) {
        TimeTests.randomNumberTimes();
    }

    public static void interpTest() {
        InterpolatingStepGenerator isg = InterpolatingStepGenerator.getBinomialGenerator();
        isg.timeTest();
    }

    private static void randomNumberTimes() {
        long t1;
        double c;
        long t0;
        int nrep = 3;
        double rnrn = 1.0E7;
        Random random = new Random();
        int i = 0;
        while (i < nrep) {
            t0 = System.currentTimeMillis();
            c = 0.0;
            int j = 0;
            while ((double)j < rnrn) {
                c += (double)random.nextFloat();
                ++j;
            }
            t1 = System.currentTimeMillis();
            System.out.println("util.random t = " + (t1 - t0));
            ++i;
        }
        i = 0;
        while (i < nrep) {
            t0 = System.currentTimeMillis();
            c = 0.0;
            int j = 0;
            while ((double)j < rnrn) {
                c += NRRandom.random();
                ++j;
            }
            t1 = System.currentTimeMillis();
            System.out.println("NRRandom t = " + (t1 - t0));
            ++i;
        }
        MersenneTwister mtw = new MersenneTwister();
        int i2 = 0;
        while (i2 < nrep) {
            long t02 = System.currentTimeMillis();
            double c2 = 0.0;
            int j = 0;
            while ((double)j < rnrn) {
                c2 += (double)mtw.random();
                ++j;
            }
            long t12 = System.currentTimeMillis();
            System.out.println("MT t = " + (t12 - t02));
            ++i2;
        }
    }
}

