/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.textensor.report.E;

public abstract class FileUtil {
    public static byte[] readHeader(File f, int n) {
        byte[] ret = null;
        try {
            FileInputStream ins = new FileInputStream(f);
            ret = new byte[n];
            int nread = ins.read(ret);
            if (nread != n) {
                E.error("readNBytes wanted " + n + " but got " + nread);
            }
            ins.close();
        }
        catch (Exception ex) {
            E.error("readNBytes problem " + ex);
        }
        return ret;
    }

    public static byte[] readBytes(File f) {
        byte[] ret = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            int nread = bis.read(bb);
            while (nread > 0) {
                baos.write(bb, 0, nread);
                nread = bis.read(bb);
            }
            ret = baos.toByteArray();
        }
        catch (Exception ex) {
            E.error("readNBytes problem " + ex);
        }
        return ret;
    }

    public static String readStringFromFile(File f) {
        String sdat = "null";
        if (f != null) {
            try {
                boolean dogz = f.getName().endsWith(".gz");
                InputStream ins = new FileInputStream(f);
                if (dogz) {
                    ins = new GZIPInputStream(ins);
                }
                InputStreamReader insr = new InputStreamReader(ins);
                BufferedReader fr = new BufferedReader(insr);
                StringBuffer sb = new StringBuffer();
                while (fr.ready()) {
                    sb.append(fr.readLine());
                    sb.append("\n");
                }
                fr.close();
                sdat = sb.toString();
            }
            catch (IOException ex) {
                E.error("file read error ");
                ex.printStackTrace();
            }
        }
        return sdat;
    }

    public static boolean writeStringToFile(String sdat, File f) {
        String fnm = f.getName();
        boolean ok = false;
        boolean dogz = fnm.endsWith(".gz");
        try {
            OutputStream fos = new FileOutputStream(f);
            if (dogz) {
                fos = new GZIPOutputStream(fos);
            }
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            osw.write(sdat, 0, sdat.length());
            osw.close();
            ok = true;
        }
        catch (IOException ex) {
            E.error("file writing error, trying to write file " + fnm);
            ex.printStackTrace();
        }
        return ok;
    }

    public static String getRootName(File f) {
        String fnm = f.getName();
        String root = fnm.substring(0, fnm.lastIndexOf("."));
        return root;
    }

    public static void writeBytes(byte[] ba, File f) {
        FileUtil.writeByteArrayToFile(ba, f);
    }

    public static void writeByteArrayToFile(byte[] ba, File f) {
        if (f == null) {
            return;
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(ba);
            ((OutputStream)os).flush();
        }
        catch (Exception e) {
            E.error("cant write byte array " + ba + " to " + f);
        }
    }

    public static void copyFile(File fsrc, File fdest) {
        if (fsrc.exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(fsrc);
                FileOutputStream out = new FileOutputStream(fdest);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                E.error("file copy exception");
            }
        } else {
            E.warning("copy - missing file " + fsrc);
        }
    }

    public static String findPath(File f, String name) {
        String ret = null;
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fs = fileArray[n2];
            if (fs.getName().equals(name)) {
                ret = "";
                break;
            }
            ++n2;
        }
        if (ret == null) {
            fileArray = f.listFiles();
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                String s;
                File fd = fileArray[n2];
                if (fd.isDirectory() && (s = FileUtil.findPath(fd, name)) != null) {
                    if (s.equals("")) {
                        ret = fd.getName();
                        break;
                    }
                    ret = String.valueOf(fd.getName()) + "/" + s;
                    break;
                }
                ++n2;
            }
        }
        return ret;
    }

    public static String readFirstLine(File f) {
        String ret = null;
        if (f != null) {
            try {
                FileInputStream ins = new FileInputStream(f);
                InputStreamReader insr = new InputStreamReader(ins);
                BufferedReader fr = new BufferedReader(insr);
                ret = fr.readLine();
                fr.close();
            }
            catch (IOException ex) {
                E.error("file read error ");
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public static String getRelativeDirectory(File ftgt, File rtFolder) {
        int ns = 0;
        String sret = null;
        for (File fpar = ftgt.getParentFile(); fpar != null && !fpar.equals(rtFolder); fpar = fpar.getParentFile()) {
            sret = sret == null ? fpar.getName() : String.valueOf(fpar.getName()) + "/" + sret;
            if (++ns <= 8) continue;
            E.error("too many steps trying to get relative files ? " + ftgt.getAbsolutePath() + " " + rtFolder.getAbsolutePath());
            break;
        }
        return sret;
    }

    public static ArrayList<File> matchingFiles(String srcPattern) {
        ArrayList<File> ret;
        block4: {
            block3: {
                ret = new ArrayList<File>();
                if (srcPattern.indexOf("*") >= 0) break block3;
                File fd = new File(srcPattern);
                if (!fd.exists() || !fd.isDirectory()) break block4;
                File[] fileArray = fd.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    ret.add(f);
                    ++n2;
                }
                break block4;
            }
            int istar = srcPattern.indexOf("*");
            String sa = srcPattern.substring(0, istar);
            String sb = srcPattern.substring(istar + 1, srcPattern.length());
            File ftop = new File(sa);
            File[] fileArray = ftop.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File fg = fileArray[n3];
                File fp = new File(fg, sb);
                if (fp.exists()) {
                    ret.add(fp);
                }
                ++n3;
            }
        }
        return ret;
    }
}

