/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.xml;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.BodyValued;
import org.textensor.xml.Attribute;
import org.textensor.xml.ReflectionInstantiator;
import org.textensor.xml.XMLChecker;
import org.textensor.xml.XMLToken;
import org.textensor.xml.XMLTokenizer;

public class XMLReader {
    ReflectionInstantiator instantiator;
    int sourceLength;
    int nerror;
    double progressFraction;

    public XMLReader(ReflectionInstantiator insta) {
        this.instantiator = insta;
    }

    public void err(String s) {
        System.out.println(s);
    }

    public Object readObject(String s) {
        return this.readFromString(s);
    }

    public Object read(String s) {
        return this.readFromString(s);
    }

    public Object readFromString(String s) {
        if ((s = XMLChecker.deGarbage(s)) == null) {
            return null;
        }
        this.progressFraction = 0.0;
        this.nerror = 0;
        this.sourceLength = new StringTokenizer(s, "\n").countTokens();
        XMLTokenizer tkz = new XMLTokenizer(s);
        XMLToken xmlt = tkz.nextToken();
        while (xmlt.isIntro() || xmlt.isComment()) {
            if (xmlt.isComment()) {
                E.info("reading comment " + xmlt);
            }
            xmlt = tkz.nextToken();
        }
        XMLHolder xmlHolder = new XMLHolder();
        this.readFieldIntoParent(tkz, xmlHolder, xmlt);
        return xmlHolder.getContent();
    }

    public XMLToken readToken(XMLTokenizer tkz) {
        XMLToken xmlt = tkz.nextToken();
        int lno = tkz.lineno();
        if (this.nerror > 4) {
            this.err("too many errors - aborting parse at line " + lno);
        }
        return xmlt;
    }

    public void readFieldIntoParent(XMLTokenizer tkz, Object parent, XMLToken start) {
        if (!start.isOpen()) {
            ++this.nerror;
            this.err("ERROR - read object start item was not an open tag " + start);
            return;
        }
        Object child = null;
        if (parent instanceof String || parent instanceof StringBuffer) {
            child = new StringBuffer();
            ((StringBuffer)child).append(start.getOpenTagString());
        } else {
            Attribute[] atts = start.getAttributes();
            child = this.instantiator.getChildObject(parent, start.getName(), atts);
            if (child != null) {
                this.instantiator.applyAttributes(child, atts);
            }
            if (child == null) {
                child = new ArrayList();
            } else if (child instanceof String) {
                child = new StringBuffer();
            } else if (child.getClass().isArray()) {
                child = new ArrayList();
            }
            if (!start.isClose()) {
                XMLToken next = this.readToken(tkz);
                while (!next.isNone()) {
                    if (next.isOpen()) {
                        this.readFieldIntoParent(tkz, child, next);
                    } else {
                        if (next.isClose()) {
                            if (next.closes(start)) {
                                if (!(parent instanceof String) && !(parent instanceof StringBuffer)) break;
                                ((StringBuffer)child).append(next.getCloseTagString());
                                break;
                            }
                            ++this.nerror;
                            E.shortError(" non-matching close item \nstart Item was: \n" + start.toString() + "\n" + "but close was: \n" + next.toString() + "\n");
                            break;
                        }
                        if (next.isString()) {
                            if (child instanceof ArrayList) {
                                E.error("attempted to read string into array list?  - ignored" + next.svalue);
                            } else if (child instanceof StringBuffer) {
                                StringBuffer sbo = (StringBuffer)child;
                                String ssf = sbo.toString();
                                if (ssf.endsWith(">") || next.svalue.startsWith("<") || ssf.length() == 0) {
                                    sbo.append(next.svalue);
                                } else {
                                    sbo.append(" ");
                                    sbo.append(next.svalue);
                                }
                            } else if (child instanceof String && ((String)child).length() > 0) {
                                child = child + " " + next.svalue;
                            } else if (child == null) {
                                child = next.svalue;
                            } else if (child instanceof Double && (Double)child == 0.0) {
                                child = new Double(next.svalue);
                            } else if (child instanceof Integer && (Integer)child == 0) {
                                child = new Integer(next.svalue);
                            } else if (child instanceof BodyValued) {
                                ((BodyValued)child).setBodyValue(next.svalue);
                            } else {
                                this.instantiator.appendContent(child, next.svalue);
                            }
                        } else if (next.isNumber()) {
                            E.shortError("XMLReader sjhould never return numbers....!!!! but just got " + next);
                        }
                    }
                    next = this.readToken(tkz);
                }
            }
            if (child instanceof StringBuffer) {
                child = ((StringBuffer)child).toString();
            }
            if (parent instanceof StringBuffer) {
                StringBuffer psb = (StringBuffer)parent;
                psb.append(child);
                psb.append("\n");
            } else if (parent instanceof XMLHolder) {
                ((XMLHolder)parent).setContent(child);
            } else if (parent instanceof ArrayList) {
                this.setListChild(parent, child);
            } else {
                this.instantiator.setField(parent, start.getName(), child);
            }
        }
    }

    private void setListChild(Object parent, Object child) {
        ((ArrayList)parent).add(child);
    }

    class XMLHolder {
        Object content;

        XMLHolder() {
        }

        public void setContent(Object obj) {
            this.content = obj;
        }

        public Object getContent() {
            return this.content;
        }
    }
}

