/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.act;

import java.util.ArrayList;
import org.catacomb.act.EnumOption;

public class FieldSignature {
    public static final int PRIVATE = 1;
    public static final int PUBLIC = 2;
    public static final int REFLECT_PUBLIC = 3;
    public int type;
    String preComment;
    ArrayList<EnumOption> enumOptions;
    String vtype;
    String name;
    boolean getter;
    boolean setter;
    boolean visible = false;

    public FieldSignature(String typ, String nm) {
        this.vtype = typ;
        this.name = nm;
        this.type = 1;
        this.getter = false;
        this.setter = false;
    }

    public void addGetter() {
        this.getter = true;
    }

    public void addSetter() {
        this.setter = true;
    }

    public void setPrivate() {
        this.type = 1;
    }

    public void setPublic() {
        this.type = 2;
    }

    public void setVisible() {
        this.visible = true;
    }

    public void setReflectable() {
        this.type = 3;
    }

    public String getJavaSource() {
        StringBuffer sb = new StringBuffer();
        if (this.preComment != null) {
            sb.append("// " + this.preComment + "\n");
        }
        if (this.enumOptions != null) {
            for (EnumOption eno : this.enumOptions) {
                sb.append(eno.toJavaDeclaration());
            }
        }
        sb.append("   ");
        if (this.type == 1) {
            sb.append("private ");
        } else if (this.type == 2 || this.type == 3) {
            sb.append("public ");
        }
        sb.append(this.vtype);
        sb.append(" ");
        sb.append(this.name);
        sb.append(";\n");
        return sb.toString();
    }

    public void addEnumOption(String nm, int val) {
        if (this.enumOptions == null) {
            this.enumOptions = new ArrayList();
        }
        this.enumOptions.add(new EnumOption(nm, val));
    }

    public String getPrefixedInfo(String pfx) {
        StringBuffer sb = new StringBuffer();
        String ufnm = this.getUName();
        if (this.getter) {
            sb.append("   " + this.vtype + " " + pfx + ".get" + ufnm + "() ");
            if (this.enumOptions != null && this.enumOptions.size() > 0) {
                sb.append("\n      possible values: ");
                int ict = 0;
                for (EnumOption eno : this.enumOptions) {
                    if (++ict % 4 == 0) {
                        sb.append("\n             ");
                    }
                    sb.append(eno.toPrefixedCodeComment(pfx));
                }
            }
        } else {
            sb.append("   " + this.vtype + "  " + pfx + "." + this.name);
        }
        return sb.toString();
    }

    public String getLocalInfo() {
        return "     " + this.vtype + " " + this.name;
    }

    private String getUName() {
        String ufnm = this.name;
        ufnm = this.name.length() == 1 ? this.name.toUpperCase() : String.valueOf(this.name.substring(0, 1).toUpperCase()) + this.name.substring(1, this.name.length());
        return ufnm;
    }

    public String getJavaAccessors() {
        StringBuffer sb = new StringBuffer();
        String ufnm = this.getUName();
        if (this.setter) {
            sb.append("   public void set" + ufnm + "(" + this.vtype + " v) {\n");
            sb.append("      this." + this.name + " = v;\n");
            sb.append("   }\n\n");
        }
        if (this.getter) {
            sb.append("   public " + this.vtype + " get" + ufnm + "() {\n");
            sb.append("      return " + this.name + ";\n");
            sb.append("   }\n\n");
        }
        return sb.toString();
    }

    public void addPreComment(String str) {
        this.preComment = str;
    }

    public boolean isPublic() {
        boolean ret = false;
        if (this.type == 2) {
            ret = true;
        }
        return ret;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

