/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.act;

import java.util.ArrayList;
import org.catacomb.act.BlockSignature;
import org.catacomb.act.CaseRelayBody;
import org.catacomb.act.MethodBody;
import org.catacomb.act.MethodStub;
import org.catacomb.report.E;

public class MethodSignature
implements BlockSignature {
    int type;
    public static final int USER_SOURCE = 1;
    public static final int SYSTEM_SOURCE = 2;
    public static final int REQUIRED_USER_SOURCE = 3;
    public static final int SUPER_SOURCE = 4;
    int sourceType;
    String info;
    String returnType;
    String functionName;
    ArrayList<String[]> args;
    String body;
    MethodBody methodBody;
    boolean userAccessible;
    boolean superdefd;

    public MethodSignature(String fn) {
        this(fn, 7);
    }

    public MethodSignature(String fn, int typ) {
        this.functionName = fn;
        this.type = typ;
        this.sourceType = 1;
        this.userAccessible = true;
        this.superdefd = false;
    }

    public void setSuperDefined() {
        this.superdefd = true;
    }

    public boolean superDefined() {
        return this.superdefd;
    }

    public void setUserSource() {
        this.sourceType = 1;
    }

    public void setSuperSource() {
        this.sourceType = 4;
    }

    public void setSystemSource() {
        this.sourceType = 2;
    }

    public void setRequiredUserSource() {
        this.sourceType = 3;
    }

    public void setReturnType(String s) {
        this.returnType = s;
    }

    public void addArgument(String typ, String nm) {
        String[] sa = new String[]{typ, nm};
        if (this.args == null) {
            this.args = new ArrayList();
        }
        this.args.add(sa);
    }

    public void setBody(String txt) {
        this.body = txt;
        this.setSystemSource();
    }

    public void setType(int ity) {
        this.type = ity;
    }

    @Override
    public int getTypeCode() {
        return this.type;
    }

    public static String getTypeInfo(int itc) {
        String ret = "";
        if (itc == 1) {
            ret = "Handlers: functions that are called when an event occurs in a connected component.";
        } else if (itc == 4) {
            ret = "Senders: these send an event to any connected components. The handler \non the receiving component will be called.";
        } else if (itc == 5) {
            ret = "Setters: these set a value for use later, but have no other effect: \nthe value is available to connected components if they ask for it";
        } else if (itc == 6) {
            ret = "Getters: give access to quantities in connected components.";
        }
        return ret;
    }

    public void setInfo(String s) {
        this.info = s;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    public String toJavaSource() {
        return this.toJavaSource("");
    }

    public String toAbstractJavaSource() {
        return this.toJavaSource(" abstract ");
    }

    public String toJavaSource(String qualifier) {
        StringBuffer sb = new StringBuffer();
        if (this.info != null) {
            if (this.info.length() > 60 || this.info.indexOf("\n") > 0) {
                sb.append("/*\n");
                sb.append("  " + this.info.replaceAll("\n", "\n  "));
                sb.append("\n*/\n");
            } else {
                sb.append("//");
                sb.append(this.info);
                sb.append("\n");
            }
        }
        sb.append("public ");
        sb.append(qualifier);
        if (this.returnType != null) {
            sb.append(String.valueOf(this.returnType) + " ");
        } else {
            sb.append("void ");
        }
        sb.append(String.valueOf(this.functionName) + "(");
        sb.append(this.writeArgs());
        sb.append(")");
        if (qualifier.indexOf("abstract") >= 0) {
            sb.append(";\n");
        } else {
            sb.append(" {\n");
            if (this.body != null) {
                sb.append(this.body);
                if (!this.body.trim().endsWith(";")) {
                    sb.append(";");
                }
                sb.append("\n");
            } else if (this.methodBody != null) {
                sb.append(this.methodBody.write());
                sb.append("\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public MethodStub getStub() {
        MethodStub ret = new MethodStub();
        if (this.info != null) {
            ret.setInfo(this.info);
        }
        ret.setVisibility("public");
        ret.setReturnType(this.returnType);
        ret.setMethodName(this.functionName);
        ret.setArgList(this.writeArgs());
        if (this.body != null || this.methodBody != null) {
            E.warning("stubs ignoring non-null body? " + this.body + " " + this.methodBody);
        }
        return ret;
    }

    private String writeArgs() {
        StringBuffer sb = new StringBuffer();
        if (this.args != null && this.args.size() > 0) {
            boolean follower = false;
            for (String[] sa : this.args) {
                if (follower) {
                    sb.append(", ");
                }
                follower = true;
                sb.append(String.valueOf(sa[0]) + " " + sa[1]);
            }
        }
        return sb.toString();
    }

    public void setUserHidden() {
        this.userAccessible = false;
    }

    public boolean emptyBody() {
        boolean ret = true;
        if (this.body != null && this.body.trim().length() > 0) {
            ret = false;
        } else if (this.methodBody != null) {
            ret = false;
        }
        return ret;
    }

    public boolean isUserAccessible() {
        return this.userAccessible;
    }

    public boolean isSuper() {
        return this.sourceType == 4;
    }

    public boolean isSystem() {
        return this.sourceType == 2;
    }

    public boolean isUser() {
        return this.sourceType == 1;
    }

    public boolean isRequiredUser() {
        return this.sourceType == 3;
    }

    public Object writeCommentSignature() {
        StringBuffer sb = new StringBuffer();
        if (this.returnType == null || this.returnType.equals("void")) {
            sb.append("   ");
        } else {
            sb.append("  " + this.returnType + " v = ");
        }
        sb.append(String.valueOf(this.functionName) + "(" + this.writeArgs() + ")");
        return sb.toString();
    }

    public void addBodyCaseRelay(String svar, String sid, String call) {
        if (this.methodBody == null) {
            this.methodBody = new CaseRelayBody(svar);
        }
        ((CaseRelayBody)this.methodBody).addCase(sid, call);
    }

    public void appendToBody(String line) {
        this.setSystemSource();
        this.body = this.body == null ? line : String.valueOf(this.body) + ";\n   " + line;
    }
}

