/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.be;

import org.catacomb.be.BasicTimestep;
import org.catacomb.be.Timestep;

public final class TimePoint {
    int istep;
    double dt;
    double time;
    double previousTime;
    double runtime;
    Timestep timestep;

    public TimePoint() {
        this.time = 0.0;
        this.dt = 1.0;
        this.runtime = 100.0;
        this.timestep = new BasicTimestep(this.dt);
    }

    public TimePoint(double dt, double t0) {
        this.istep = 0;
        this.dt = dt;
        this.time = t0;
        this.previousTime = t0 - dt;
    }

    public void setDt(double d) {
        this.dt = d;
        this.timestep = new BasicTimestep(this.dt);
    }

    public void setRuntime(double d) {
        this.runtime = d;
    }

    public boolean isFinished() {
        return this.time >= this.runtime;
    }

    public double getProgressFraction() {
        if (this.runtime <= 0.0) {
            this.runtime = 1.0;
        }
        return this.time / this.runtime;
    }

    public String getProgressDescription() {
        Long ns = new Long(Math.round(this.runtime / this.dt));
        Integer iso = new Integer(this.istep > 0 ? this.istep - 1 : 0);
        String ret = String.format("step %d of %d (t=%.4g)", iso, ns, new Double(this.time));
        return ret;
    }

    public double getTime() {
        return this.time;
    }

    public double getPreviousTime() {
        return this.previousTime;
    }

    public double getDt() {
        return this.dt;
    }

    public int getStep() {
        return this.istep;
    }

    public void increment() {
        this.previousTime = this.time;
        this.time += this.dt;
        ++this.istep;
    }

    public Timestep getTimestep() {
        return this.timestep;
    }
}

