/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.catacomb.dataview.AxisPainter;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.WorldTransform;
import org.catacomb.report.E;

public class GraphMaker {
    String xlabel = null;
    String ylabel = null;
    double xmin = 0.0;
    double xmax = 1.0;
    double ymin = 0.0;
    double ymax = 1.0;
    Graphics2D graphics;
    Painter painter;
    int leftMargin = 70;
    int bottomMargin = 48;
    int topMargin = 0;
    int rightMargin = 0;
    int width;
    int height;
    BufferedImage image;

    public GraphMaker(int w, int h, Color cbg) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.image = new BufferedImage(w, h, 1);
        this.graphics = ge.createGraphics(this.image);
        if (cbg != null) {
            this.graphics.setColor(cbg);
        } else {
            this.graphics.setColor(Color.gray);
        }
        this.graphics.fillRect(0, 0, w, h);
        this.width = w;
        this.height = h;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void setXAxisLabel(String xl) {
        this.xlabel = xl;
    }

    public void setYAxisLabel(String yl) {
        this.ylabel = yl;
    }

    public void setXRange(double a, double b) {
        this.xmin = a;
        this.xmax = b;
    }

    public void setYRange(double a, double b) {
        this.ymin = a;
        this.ymax = b;
    }

    public void drawData(PaintInstructor pin, File fout) {
        WorldTransform wt = new WorldTransform();
        wt.setMargins(this.leftMargin, this.rightMargin, this.bottomMargin, this.topMargin);
        wt.setCanvasSize(this.width, this.height);
        wt.setXYXYLimits(this.xmin, this.ymin, this.xmax, this.ymax);
        this.painter = new Painter(wt);
        this.painter.setGraphics(this.graphics);
        pin.instruct(this.painter);
        AxisPainter ap = new AxisPainter(this.graphics, wt);
        ap.drawAxes();
        ap.labelAxes(this.xlabel, this.ylabel);
        try {
            ImageIO.write((RenderedImage)this.image, "PNG", fout);
        }
        catch (Exception ex) {
            E.error("cant write " + fout + " " + ex);
        }
    }
}

