/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.catacomb.dataview.formats.DataReader;
import org.catacomb.dataview.formats.TableDataHandler;
import org.catacomb.report.E;

public class TableDataReader
implements DataReader {
    TableDataHandler handler;
    int ncol;
    String[] columnNames;
    ArrayList<double[]> data;

    public TableDataReader(TableDataHandler tdh) {
        this.handler = tdh;
        this.data = new ArrayList();
    }

    @Override
    public boolean canRead(String line) {
        boolean ret = false;
        if (line.startsWith("tableColumnNames") || line.startsWith("tableRow")) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void readBlock(String line, BufferedReader br) {
        if (line.startsWith("tableColumnNames")) {
            StringTokenizer st = new StringTokenizer(line, " ");
            st.nextToken();
            st.nextToken();
            this.ncol = Integer.parseInt(st.nextToken());
            this.columnNames = new String[this.ncol];
            int nread = 0;
            while (nread < this.ncol) {
                try {
                    String sline = br.readLine();
                    StringTokenizer xst = new StringTokenizer(sline);
                    while (xst.hasMoreTokens() && nread < this.ncol) {
                        this.columnNames[nread] = xst.nextToken();
                        ++nread;
                    }
                }
                catch (Exception ex) {
                    E.error("cant read line needed in table data reader " + ex);
                }
            }
        } else if (line.startsWith("tableRow")) {
            StringTokenizer st = new StringTokenizer(line, " ");
            st.nextToken();
            st.nextToken();
            int ndat = Integer.parseInt(st.nextToken());
            double[] dat = new double[ndat];
            int nread = 0;
            try {
                while (nread < this.ncol) {
                    String sline = br.readLine();
                    StringTokenizer xst = new StringTokenizer(sline);
                    while (xst.hasMoreTokens() && nread < this.ncol) {
                        dat[nread] = Double.parseDouble(xst.nextToken());
                        ++nread;
                    }
                }
            }
            catch (Exception ex) {
                E.error("read error " + ex);
            }
            if (dat.length != this.ncol) {
                E.error("wrong length data in table reader: need " + this.ncol + " but got " + dat.length);
            } else {
                this.data.add(dat);
            }
        } else {
            E.error("cant read " + line);
        }
    }

    public void fix() {
        this.handler.setColumnNames(this.columnNames);
        double[][] db = new double[this.ncol][this.data.size()];
        int i = 0;
        while (i < this.data.size()) {
            double[] dat = this.data.get(i);
            int j = 0;
            while (j < this.ncol) {
                db[j][i] = dat[j];
                ++j;
            }
            ++i;
        }
        this.handler.setData(db);
    }
}

