/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.model;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.catacomb.datalish.SColor;
import org.catacomb.dataview.display.Displayable;
import org.catacomb.numeric.data.AsciiIO;
import org.catacomb.report.E;

public abstract class Plottable {
    public String file;
    public SColor color;
    public double width;
    public String rescale;
    public String label;
    public String function;

    public abstract ArrayList<Displayable> getDisplayables(File var1);

    public Color getColor() {
        Color ret = Color.white;
        if (this.color != null) {
            ret = this.color.getColor();
        }
        return ret;
    }

    public double[] getScaleFactors(int nsf) {
        double[] ret = new double[nsf];
        int i = 0;
        while (i < nsf) {
            ret[i] = 1.0;
            ++i;
        }
        if (this.rescale != null) {
            double[] row = AsciiIO.readRow(this.rescale);
            if (row == null) {
                E.warning("cant read scale factors from " + this.rescale);
            } else {
                int i2 = 0;
                while (i2 < nsf && i2 < row.length) {
                    ret[i2] = row[i2];
                    ++i2;
                }
            }
        }
        return ret;
    }

    protected double[] scaleColumn(double[] d, double sf) {
        double[] ret = new double[d.length];
        int i = 0;
        while (i < d.length) {
            ret[i] = sf * d[i];
            ++i;
        }
        return ret;
    }
}

