/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.read;

import java.io.File;
import org.catacomb.dataview.read.ContentReader;
import org.catacomb.dataview.read.FUImportContext;
import org.catacomb.dataview.read.Importer;

public class FileImportContext
extends FUImportContext {
    File baseFile;
    File baseDir;

    public FileImportContext(File f) {
        this.baseFile = f;
        this.baseDir = f.getParentFile();
    }

    @Override
    public boolean hasRelative(String sr) {
        File fr = new File(this.baseDir, sr);
        return fr.exists();
    }

    @Override
    public File getRelativeFile(String sr) {
        File fr = new File(this.baseDir, sr);
        return fr;
    }

    @Override
    public ContentReader getRelativeReader(String sr) {
        File file = this.getRelativeFile(sr);
        return Importer.getReader(file);
    }

    @Override
    public String getExtensionRelativeName(String ext) {
        return this.getReExtendedName(this.baseFile.getName(), ext);
    }
}

