/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.catacomb.druid.build.DruidTargetStore;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.market.HookupBoard;
import org.catacomb.interlish.structure.InfoReceiver;
import org.catacomb.interlish.structure.Marketplace;
import org.catacomb.interlish.structure.TargetStore;

public class GUIStore {
    DruidTargetStore targetStore;
    HashMap<String, ArrayList<Object>> withoutIDs;
    ArrayList<Object> allComponents;
    InfoReceiver infoReceiver;

    public GUIStore() {
        this.reset();
    }

    public void reset() {
        this.targetStore = new DruidTargetStore();
        this.withoutIDs = new HashMap();
        this.allComponents = new ArrayList();
    }

    public void addComponent(Object obj, GUIPath gpath) {
        if (gpath.isUnique()) {
            this.addIDdComponent(obj, gpath.getPath());
        } else {
            this.addAnonymousComponent(obj, gpath.getPath());
        }
        this.allComponents.add(obj);
    }

    public HashMap<String, ArrayList<Object>> getAnonymousComponentMap() {
        return this.withoutIDs;
    }

    public HashMap<String, Object> getIdentifiedComponentMap() {
        return this.targetStore.getIdentifiedComponentMap();
    }

    public void addIDdComponent(Object obj, String id) {
        this.targetStore.addComponent(id, obj);
    }

    public void addAnonymousComponent(Object obj, String path) {
        if (this.withoutIDs.containsKey(path)) {
            this.withoutIDs.get(path).add(obj);
        } else {
            ArrayList<Object> arl = new ArrayList<Object>();
            arl.add(obj);
            this.withoutIDs.put(path, arl);
        }
    }

    public String getTextDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n uniquely identified components\n");
        this.appendHM(sb, this.targetStore.getHashMap());
        sb.append("\n\n");
        sb.append("generic container components\n");
        this.appendHM(sb, this.withoutIDs);
        sb.append("\n\n");
        return sb.toString();
    }

    private void appendHM(StringBuffer sb, HashMap<String, ? extends Object> hm) {
        for (String s : hm.keySet()) {
            sb.append("   ");
            sb.append(s);
            sb.append("\n");
        }
    }

    public TargetStore getTargetStore() {
        return this.targetStore;
    }

    public ArrayList getComponents() {
        return this.allComponents;
    }

    public void setHookupBoard(HookupBoard hb) {
        this.targetStore.setHookupBoard(hb);
    }

    public HookupBoard getHookupBoard() {
        return this.targetStore.getHoookupBoard();
    }

    public void setInfoReceiver(InfoReceiver ir) {
        this.infoReceiver = ir;
        this.targetStore.setInfoReceiver(ir);
    }

    public InfoReceiver getInfoReceiver() {
        return this.infoReceiver;
    }

    public void clear() {
        this.targetStore.clear();
    }

    public HashMap<String, Object> getIdentifiedComponents() {
        return this.targetStore.getHashMap();
    }

    public ArrayList<Object> getAnonymousComponents() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Map.Entry<String, ArrayList<Object>> entry : this.withoutIDs.entrySet()) {
            ret.addAll((Collection<Object>)entry.getValue());
        }
        return ret;
    }

    public Marketplace getMarketplace() {
        return this.getHookupBoard();
    }
}

