/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.chunk;

import java.util.ArrayList;
import org.catacomb.interlish.annotation.Editable;
import org.catacomb.interlish.content.BooleanValue;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.ModeController;
import org.catacomb.interlish.structure.ModeSettable;
import org.catacomb.report.E;

public class MouseModeController
implements Controller,
ModeController {
    ArrayList<ModeSettable> modeSettables = new ArrayList();
    @Editable(xid="antialias")
    public BooleanValue antialiasBV = new BooleanValue(false);
    @Editable(xid="labels")
    public BooleanValue labelsBV = new BooleanValue(false);

    @Override
    public void addModeSettable(ModeSettable ms) {
        this.modeSettables.add(ms);
        this.setLabels(this.labelsBV.getBoolean());
    }

    @Override
    public void attached() {
    }

    public void reframe() {
        for (ModeSettable ms : this.modeSettables) {
            ms.setMode("showAll", true);
        }
    }

    public void setAntialias(boolean b) {
        if (b == this.antialiasBV.getBoolean()) {
            for (ModeSettable ms : this.modeSettables) {
                ms.setMode("antialias", b);
            }
        } else {
            E.error("out of sync");
        }
    }

    public void setLabels(boolean b) {
        if (b == this.labelsBV.getBoolean()) {
            for (ModeSettable ms : this.modeSettables) {
                ms.setMode("labels", b);
            }
        } else {
            E.error("out of sync");
        }
    }

    private void exportMode(String mode, String val) {
        for (ModeSettable ms : this.modeSettables) {
            ms.setMode(mode, val);
        }
    }

    public void setMouseMode(String s) {
        E.info("mouse mode panel setting mode " + s);
        this.exportMode("mouse", s);
    }

    public void setPan(boolean b) {
        this.exportMode("mouse", "pan");
    }

    public void setZoomIn(boolean b) {
        this.exportMode("mouse", "zoomIn");
    }

    public void setZoomOut(boolean b) {
        this.exportMode("mouse", "zoomOut");
    }

    public void setBox(boolean b) {
        this.exportMode("mouse", "box");
    }

    public void setMulti(boolean b) {
        this.exportMode("mouse", "all");
    }
}

