/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.Effect;
import org.catacomb.druid.swing.DLabel;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.druid.swing.DTextField;
import org.catacomb.druid.swing.DValueHistory;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.TextField;
import org.catacomb.interlish.structure.UseWatcher;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class DruLabelledTextField
extends DruGCPanel
implements TextActor,
Ablable,
TextField,
ValueWatcher,
UseWatcher,
LabelActor {
    static final long serialVersionUID = 1001L;
    DLabel dLabel;
    DTextField dTextField;
    DPanel dpanel;
    StringValue stringValue;
    DValueHistory dValueHistory;
    String focusAction;
    ArrayList<Effect> effects;

    public DruLabelledTextField() {
        this("", null, 20, false);
    }

    public DruLabelledTextField(String s) {
        this("", s, s.length(), false);
    }

    public DruLabelledTextField(String lbl, String mn, int width, boolean withHist) {
        this.dTextField = new DTextField("", width);
        this.setActionMethod(mn);
        this.dLabel = new DLabel(lbl);
        this.dpanel = new DPanel();
        this.dpanel.setBorderLayout(4, 0);
        this.dpanel.add((Component)this.dLabel, "West");
        this.dpanel.add((Component)this.dTextField, "Center");
        if (withHist) {
            this.dValueHistory = new DValueHistory();
            this.dValueHistory.setLabelActor(this);
            this.dpanel.add((Component)this.dValueHistory, "East");
        }
        this.addSingleDComponent(this.dpanel);
        this.dTextField.setTextActor(this);
        this.setLineBorder(0xC0C0C0);
    }

    @Override
    public void setBg(Color c) {
        this.dpanel.setBg(c);
        this.dLabel.setBg(c);
        this.dTextField.setBg(c);
        if (this.dValueHistory != null) {
            this.dValueHistory.setBg(c);
        }
        super.setBg(c);
    }

    @Override
    public void valueChangedBy(Value pv, Object src) {
        if (src != this) {
            if (this.stringValue == pv) {
                if (this.stringValue == null) {
                    this.dTextField.setText("");
                    this.able(false);
                } else {
                    this.dTextField.setText(this.stringValue.getString());
                    this.able(this.stringValue.isAble());
                }
            } else {
                E.error("value changed by called with mismatched value");
            }
        }
    }

    @Override
    public void usedBy(Value pv, Object src) {
        if (src != this && this.dValueHistory != null) {
            this.dValueHistory.checkContains(((StringValue)pv).silentGetAsString());
        }
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.stringValue.reportableSetString(s, this);
        this.dTextField.setText(s);
    }

    @Override
    public void setEditable(boolean b) {
        this.dTextField.setEditable(b);
        this.dTextField.setEnabled(b);
    }

    @Override
    public void able(boolean b) {
        this.dTextField.setEnabled(b);
    }

    @Override
    public void setStringValue(StringValue sv) {
        if (this.stringValue != null) {
            this.stringValue.removeValueWatcher(this);
            this.stringValue.removeUseWatcher(this);
        }
        this.stringValue = sv;
        if (this.stringValue == null) {
            this.able(false);
        } else {
            this.dTextField.setText(this.stringValue.getString());
            this.stringValue.addValueWatcher(this);
            this.stringValue.addUseWatcher(this);
            this.able(this.stringValue.isAble());
        }
    }

    public void setLineBorder(int icol) {
        this.dTextField.setLineBorder(icol);
    }

    @Override
    public void textChanged(String s) {
        this.stringValue.reportableSetString(this.dTextField.getText(), this);
        this.syncEffects();
    }

    @Override
    public void textEntered(String s) {
        if (this.hasAction()) {
            this.action();
        }
        this.syncEffects();
    }

    @Override
    public void textEdited(String s) {
        this.stringValue.editCompleted();
        this.syncEffects();
    }

    private void syncEffects() {
        if (this.effects != null) {
            for (Effect eff : this.effects) {
                eff.apply(true);
            }
        }
    }

    public void setReturnAction(String action) {
        this.setAction(action);
        this.dTextField.enableReturnEvents();
    }

    public void setFocusAction(String faction) {
        this.focusAction = faction;
        this.dTextField.enableFocusEvents();
    }

    @Override
    public void focusGained() {
        if (this.focusAction != null) {
            this.performAction(this.focusAction, true);
        }
    }

    @Override
    public void focusLost() {
        if (this.focusAction != null) {
            this.performAction(this.focusAction, false);
        }
    }

    public void setEffects(ArrayList<Effect> arl) {
        this.effects = arl;
    }
}

