/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.load;

import java.io.File;
import org.catacomb.serial.quickxml.XMLFileElement;

public class Settings {
    XMLFileElement xrecent;
    XMLFileElement xpref;

    public Settings(String appname) {
        File fapp;
        File fuser = new File(System.getProperty("user.home"));
        File fccmb = new File(fuser, ".catacomb");
        if (!fccmb.exists()) {
            fccmb.mkdir();
        }
        if (!(fapp = new File(fccmb, appname)).exists()) {
            fapp.mkdir();
        }
        this.xrecent = new XMLFileElement(fapp, "recent");
        this.xpref = new XMLFileElement(fapp, "preferences");
    }

    public void addRecentFile(File f) {
        this.addRecentPath(f.getAbsolutePath());
    }

    public void addRecentPath(String fpath) {
        this.xrecent.prependElementUnique("path", fpath);
        this.xrecent.limitNumber("path", 10);
        this.xrecent.sync();
    }

    public String[] getRecentPaths() {
        return this.xrecent.getValues("path");
    }

    public void addElement(String name, String value) {
        this.xpref.prependElementUnique(name, value);
        this.xpref.sync();
    }

    public boolean hasElement(String name, String value) {
        return this.xpref.hasElement(name, value);
    }

    public boolean hasElement(String name) {
        return this.xpref.hasElement(name);
    }

    public String getValue(String eltname) {
        return this.xpref.getValue(eltname);
    }

    public void setElement(String name, String value) {
        this.xpref.setElement(name, value);
        this.xpref.sync();
    }
}

