/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.CheckListCellRenderer;
import org.catacomb.druid.swing.ToggleItem;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.Named;
import org.catacomb.report.E;

public class DCheckboxList
extends JList
implements DComponent,
ListSelectionListener,
MouseListener {
    static final long serialVersionUID = 1001L;
    static Font boldfont;
    public LabelActor labelActor;
    Object bufSel;
    boolean dropEvents;
    int hotspot;
    ToggleItem[] toggleItems;
    HashMap<String, ToggleItem> tiHM;
    ToggleItem activeTI;
    boolean multiple;

    public DCheckboxList() {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.dropEvents = false;
        this.addListSelectionListener(this);
        this.setCellRenderer(new CheckListCellRenderer(this.getCellRenderer()));
        this.addMouseListener(this);
        this.tiHM = new HashMap();
    }

    @Override
    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setBg(Color c) {
        this.setBackground(c);
    }

    public void setMultiple() {
        this.multiple = true;
        super.setSelectionMode(2);
    }

    public void setLabelActor(LabelActor la) {
        this.labelActor = la;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!this.dropEvents && !lse.getValueIsAdjusting()) {
            Object obj = this.getSelectedValue();
            this.activeTI = (ToggleItem)obj;
            if (obj != null && obj != this.bufSel && this.labelActor != null) {
                this.bufSel = obj;
                this.labelActor.labelAction("selected", true);
            }
        }
        this.repaint();
    }

    public void selectAt(int i) {
        this.dropEvents = true;
        this.setSelectedIndex(i);
        this.dropEvents = false;
    }

    private void toggleSelection(int index) {
        if (index >= 0) {
            this.toggleItems[index].toggle();
            this.activeTI = this.toggleItems[index];
            this.repaint();
            if (this.labelActor != null) {
                this.labelActor.labelAction("toggle", this.toggleItems[index].isOn());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int x = me.getX();
        int index = this.locationToIndex(me.getPoint());
        if (x <= 16 && index >= 0 && index < this.toggleItems.length) {
            this.toggleSelection(index);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setItems(String[] sa) {
        Object[] oa = new Object[sa.length];
        int i = 0;
        while (i < sa.length) {
            oa[i] = sa[i];
            ++i;
        }
        this.setItems(oa);
    }

    private String getLabel(Object obj) {
        String ret = null;
        ret = obj instanceof Named ? ((Named)obj).getName() : obj.toString();
        return ret;
    }

    public void setItems(Object[] oa) {
        ToggleItem[] ati = new ToggleItem[oa.length];
        int i = 0;
        while (i < oa.length) {
            String key = this.getLabel(oa[i]);
            ati[i] = this.tiHM.containsKey(key) ? this.tiHM.get(key) : new ToggleItem(oa[i]);
            ++i;
        }
        this.toggleItems = ati;
        this.tiHM.clear();
        ToggleItem[] toggleItemArray = ati;
        int n = ati.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleItem ti = toggleItemArray[n2];
            this.tiHM.put(ti.toString(), ti);
            ++n2;
        }
        this.setListData(ati);
    }

    public ArrayList<Object> getCheckedItems() {
        ArrayList<Object> ret = new ArrayList<Object>();
        int i = 0;
        while (i < this.toggleItems.length) {
            if (this.toggleItems[i].isOn()) {
                ret.add(this.toggleItems[i].getRef());
            }
            ++i;
        }
        return ret;
    }

    public ArrayList<Object> getAllItems() {
        ArrayList<Object> ret = new ArrayList<Object>();
        int i = 0;
        while (i < this.toggleItems.length) {
            ret.add(this.toggleItems[i].getRef());
            ++i;
        }
        return ret;
    }

    public int[] getCheckedIndexes() {
        int[] wk = new int[this.toggleItems.length];
        int non = 0;
        int i = 0;
        while (i < this.toggleItems.length) {
            if (this.toggleItems[i].isOn()) {
                wk[non++] = i;
            }
            ++i;
        }
        int[] ret = new int[non];
        int i2 = 0;
        while (i2 < non) {
            ret[i2] = wk[i2];
            ++i2;
        }
        return ret;
    }

    public void setCheckedIndexes(int[] inds) {
        int i = 0;
        while (i < this.toggleItems.length) {
            this.toggleItems[i].setOff();
            ++i;
        }
        i = 0;
        while (i < inds.length) {
            this.toggleItems[inds[i]].setOn();
            ++i;
        }
        this.repaint();
    }

    public Object getLastSelected() {
        Object ret = null;
        if (this.activeTI != null) {
            ret = this.activeTI.getRef();
        }
        return ret;
    }

    public boolean hasActiveSelected() {
        boolean ret = false;
        if (this.activeTI != null) {
            ret = this.activeTI.isOn();
        }
        return ret;
    }

    public void selectAll() {
        this.dropEvents = true;
        ToggleItem[] toggleItemArray = this.toggleItems;
        int n = this.toggleItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleItem ti = toggleItemArray[n2];
            ti.setOn();
            ++n2;
        }
        this.dropEvents = false;
        this.repaint();
    }

    public void setSelected(int[] ia) {
        this.dropEvents = true;
        Object[] objectArray = this.toggleItems;
        int n = this.toggleItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleItem ti = objectArray[n2];
            ti.setOff();
            ++n2;
        }
        if (ia != null) {
            objectArray = ia;
            n = ia.length;
            n2 = 0;
            while (n2 < n) {
                ToggleItem i = objectArray[n2];
                if (i >= 0 && i < this.toggleItems.length) {
                    this.toggleItems[i].setOn();
                }
                ++n2;
            }
        }
        this.dropEvents = false;
        this.repaint();
    }

    public void setSelected(String[] sa) {
        this.dropEvents = true;
        Object[] objectArray = this.toggleItems;
        int n = this.toggleItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleItem ti = objectArray[n2];
            ti.setOff();
            ++n2;
        }
        if (sa != null) {
            objectArray = sa;
            n = sa.length;
            n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (this.tiHM.containsKey(s)) {
                    this.tiHM.get(s).setOn();
                } else {
                    E.warning("Checkbox List - trying to select an item that is not in the list: " + (String)s);
                }
                ++n2;
            }
        }
        this.dropEvents = false;
        this.repaint();
    }

    public void setToggleAction() {
        E.missing();
    }
}

