/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import org.catacomb.druid.dialog.Dialoguer;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.OptionsSource;
import org.catacomb.druid.swing.DMenuItem;
import org.catacomb.druid.swing.RolloverEffect;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.lang.U;
import org.catacomb.interlish.structure.Updatable;

public class DChoice
extends JButton
implements DComponent,
ActionListener,
LabelActor,
Icon,
MouseListener {
    static final long serialVersionUID = 1001L;
    LabelActor lact;
    JPopupMenu menu;
    String[] options;
    String[] labels;
    String selected;
    RolloverEffect rollover;
    OptionsSource optionsSource;
    Updatable updatable;
    int autoSelect;
    String prefTooltip = null;

    public DChoice(String[] opts, String[] labs) {
        super("none");
        this.setIcon(this);
        this.setFont(new Font("sansserif", 0, 12));
        this.rollover = new RolloverEffect(this);
        this.addMouseListener(this.rollover);
        this.addActionListener(this);
        this.addMouseListener(this);
        this.setFocusPainted(false);
        this.setOptions(opts, labs);
        this.autoSelect = -1;
    }

    @Override
    public void setTooltip(String s) {
        this.prefTooltip = s;
        this.setToolTipText(s);
    }

    public void setAutoSelect(int ias) {
        this.autoSelect = ias;
        this.progSelect();
    }

    public void setBg(Color c) {
        this.setBackground(c);
        this.menu.setBackground(c);
        this.rollover.setBg(c);
    }

    public void setOptionsSource(OptionsSource os) {
        this.optionsSource = os;
    }

    public void setOptions(String[] optsin, String[] labsin) {
        String[] opts = optsin;
        String[] labs = labsin;
        if (opts == null) {
            opts = new String[]{};
            labs = new String[]{};
        }
        if (labs == null || labs.length == 0) {
            labs = new String[opts.length];
        } else if (labs.length < opts.length) {
            String[] olabs = labs;
            labs = new String[opts.length];
            int i = 0;
            while (i < olabs.length) {
                labs[i] = olabs[i];
                ++i;
            }
        }
        int i = 0;
        while (i < opts.length) {
            if (labs[i] == null) {
                labs[i] = opts[i];
            }
            ++i;
        }
        boolean stillIn = false;
        this.options = opts;
        this.labels = labs;
        this.menu = new JPopupMenu();
        DMenuItem dminone = new DMenuItem("none");
        dminone.setLabelActor(this);
        this.menu.add(dminone);
        this.menu.addSeparator();
        int i2 = 0;
        while (i2 < opts.length) {
            if (opts[i2].equals(this.selected)) {
                stillIn = true;
            }
            DMenuItem dmi = new DMenuItem(labs[i2], opts[i2]);
            dmi.setLabelActor(this);
            this.menu.add(dmi);
            ++i2;
        }
        if (this.selected == null || !stillIn) {
            this.progSelect();
        }
    }

    private void progSelect() {
        if (this.autoSelect >= 0 && this.options != null && this.options.length > this.autoSelect) {
            this.labelAction(this.options[this.autoSelect], true);
        } else {
            this.setSelected(null);
        }
    }

    public void checkOptions() {
        if (this.updatable != null) {
            this.updatable.update(0);
        }
        if (this.optionsSource != null) {
            String[] sa = this.optionsSource.getOptions();
            if (sa == null) {
                sa = new String[]{};
            }
            String[] sb = this.optionsSource.getLabels();
            boolean neednew = false;
            if (this.options == null || this.options.length != sa.length) {
                neednew = true;
            } else {
                int i = 0;
                while (i < this.options.length) {
                    if (!this.options[i].equals(sa[i])) {
                        neednew = true;
                        break;
                    }
                    ++i;
                }
            }
            if (neednew) {
                this.setOptions(sa, sb);
            }
        }
    }

    public void setSelected(String s) {
        if (!this.selectOne(s)) {
            if (s == null || s.equals("") || s.equals("null") || s.equals("none")) {
                this.setText("none");
                this.selected = "none";
            } else {
                this.checkOptions();
                if (!this.selectOne(s)) {
                    String msg = "Warning the selection " + s + "\n" + "is no longer available. The selection will be unset -b-" + "The possible values are: -b-";
                    String[] stringArray = this.options;
                    int n = this.options.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sopt = stringArray[n2];
                        msg = String.valueOf(msg) + sopt + "-b-";
                        ++n2;
                    }
                    Dialoguer.message(msg);
                }
            }
        }
    }

    private boolean selectOne(String s) {
        boolean ok = false;
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].equals(s)) {
                ok = true;
                this.selected = s;
                String otxt = this.getText();
                if (!U.differ(otxt, this.labels[i])) break;
                String sl = this.labels[i];
                int sll = sl.length();
                if (sll > 22) {
                    this.setToolTipText(sl);
                    sl = "..." + sl.substring(sll - 19, sll);
                    this.setText(sl);
                    break;
                }
                this.setToolTipText(this.prefTooltip);
                this.setText(sl);
                break;
            }
            ++i;
        }
        return ok;
    }

    public String getSelected() {
        return this.selected;
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.setSelected(s);
        this.deliverAction(s, true);
    }

    @Override
    public void actionPerformed(ActionEvent aev) {
    }

    public void stateChanged(ChangeEvent cev) {
    }

    public void showMenu() {
        this.checkOptions();
        this.menu.show(this, 0, 18);
    }

    @Override
    public String toString() {
        String sret = "DChoice";
        if (this.options != null && this.options.length > 0) {
            sret = String.valueOf(sret) + " first opt=" + this.options[0];
        }
        return sret;
    }

    public void setLabelActor(LabelActor bl) {
        this.lact = bl;
    }

    public void deliverAction(String s, boolean b) {
        if (this.lact != null) {
            this.lact.labelAction(s, b);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        JComponent component = (JComponent)c;
        int iconWidth = this.getIconWidth();
        g.translate(x, y);
        g.setColor(component.isEnabled() ? Color.gray : Color.blue);
        g.drawLine(2, 0, iconWidth - 1, 0);
        g.drawLine(3, 1, 1 + (iconWidth - 3), 1);
        g.drawLine(5, 3, 3 + (iconWidth - 7), 3);
        g.drawLine(6, 4, 4 + (iconWidth - 9), 4);
        g.translate(-x, -y);
    }

    @Override
    public int getIconWidth() {
        return 12;
    }

    @Override
    public int getIconHeight() {
        return 5;
    }

    public void setUpdatable(Updatable u) {
        this.updatable = u;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showMenu();
    }

    public void clearSelection() {
        this.setSelected(null);
    }
}

