/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.tree.TreePath;
import org.catacomb.druid.swing.DTree;
import org.catacomb.druid.swing.dnd.DdndTransferable;
import org.catacomb.druid.swing.dnd.DragAndDrop;
import org.catacomb.report.E;

public class DTreeDragSource
implements DragSourceListener,
DragSourceMotionListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    DdndTransferable transferable;
    DTree sourceTree;
    BufferedImage dragImg;
    Point imgOffset;

    public DTreeDragSource(DTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.source.addDragSourceMotionListener(this);
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        String sdrag = path.getLastPathComponent().toString();
        this.transferable = new DdndTransferable(path);
        Point ptDragOrigin = dge.getDragOrigin();
        Rectangle raPath = this.sourceTree.getPathBounds(path);
        int rw = (int)raPath.getWidth();
        int rh = (int)raPath.getHeight();
        this.dragImg = new BufferedImage(rw, rh, 2);
        Graphics2D g2 = this.dragImg.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        g2.setColor(Color.white);
        g2.fillRect(0, 0, rw, rh);
        g2.setComposite(AlphaComposite.getInstance(2, 1.0f));
        g2.setColor(Color.blue);
        g2.drawString(sdrag, 14, 16);
        this.imgOffset = new Point(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        DragAndDrop.getDnD().setDragImage(this.dragImg, this.imgOffset);
        this.source.startDrag(dge, Cursor.getPredefinedCursor(12), this.dragImg, this.imgOffset, this.transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        System.out.println("Action: " + dsde.getDropAction());
        System.out.println("Target Action: " + dsde.getTargetActions());
        System.out.println("User Action: " + dsde.getUserAction());
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        E.info("Drop Action: " + dsde.getDropAction());
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2) {
            E.info("was move - should remove original");
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
    }
}

