/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.split;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import org.catacomb.druid.swing.split.DSplitterSpace;
import org.catacomb.druid.swing.split.SplitterBarMouseListener;
import org.catacomb.druid.swing.split.SplitterBarMouseMotionListener;
import org.catacomb.druid.swing.split.SplitterLayout;
import org.catacomb.interlish.interact.DComponent;

public class DSplitterBar
extends JPanel
implements DComponent {
    private static final long serialVersionUID = 1L;
    static final Cursor VERT_CURSOR = new Cursor(8);
    static final Cursor HORIZ_CURSOR = new Cursor(11);
    static final Cursor DEF_CURSOR = new Cursor(0);
    private int orientation = 0;
    private boolean alreadyDrawn = false;
    private Rectangle originalBounds = null;
    private Window wBar;

    public DSplitterBar() {
        this.addMouseMotionListener(new SplitterBarMouseMotionListener(this));
        this.addMouseListener(new SplitterBarMouseListener(this));
    }

    private void checkOtherComponents() {
        block50: {
            int origCurr;
            int curr;
            Rectangle parentBounds;
            Insets insets;
            Component[] comps;
            Rectangle currBounds;
            block48: {
                block49: {
                    currBounds = this.getBounds();
                    comps = this.getParent().getComponents();
                    insets = this.getParent().getInsets();
                    parentBounds = this.getParent().getBounds();
                    curr = 0;
                    while (curr < comps.length && comps[curr] != this) {
                        ++curr;
                    }
                    origCurr = curr;
                    if (this.orientation != 0) break block48;
                    if (currBounds.y >= this.originalBounds.y) break block49;
                    boolean done = false;
                    int temp = curr - 1;
                    while (!done && temp > -1) {
                        if (comps[temp] instanceof DSplitterBar) {
                            Rectangle r = comps[temp].getBounds();
                            if (currBounds.y <= r.y + r.height) {
                                comps[temp].setLocation(r.x, currBounds.y - r.height);
                                int c = curr - 1;
                                while (c > temp) {
                                    comps[c].setVisible(false);
                                    --c;
                                }
                                curr = temp;
                                currBounds = comps[temp].getBounds();
                            } else {
                                done = true;
                            }
                        }
                        --temp;
                    }
                    if (currBounds.y <= insets.top) {
                        int delta = currBounds.y - insets.top;
                        int temp2 = curr - 1;
                        while (temp2 > -1) {
                            comps[temp2].setVisible(false);
                            --temp2;
                        }
                        done = false;
                        temp2 = curr;
                        while (!done && temp2 <= origCurr) {
                            if (comps[temp2] instanceof DSplitterBar) {
                                Point p = comps[temp2].getLocation();
                                p.y -= delta;
                                comps[temp2].setLocation(p);
                            } else {
                                done = comps[temp2].isVisible();
                            }
                            ++temp2;
                        }
                    }
                    curr = origCurr;
                    temp = curr + 1;
                    while (temp < comps.length && !comps[temp].isVisible()) {
                        comps[temp].setVisible(true);
                        ++temp;
                    }
                    break block50;
                }
                if (currBounds.y <= this.originalBounds.y) break block50;
                boolean done = false;
                int temp = curr + 1;
                while (!done && temp < comps.length) {
                    if (comps[temp] instanceof DSplitterBar) {
                        Rectangle r = comps[temp].getBounds();
                        if (currBounds.y + currBounds.height >= r.y) {
                            comps[temp].setLocation(r.x, currBounds.y + currBounds.height);
                            int c = curr + 1;
                            while (c < temp) {
                                comps[c].setVisible(false);
                                ++c;
                            }
                            curr = temp;
                            currBounds = comps[temp].getBounds();
                        } else {
                            done = true;
                        }
                    }
                    ++temp;
                }
                if (currBounds.y + currBounds.height >= parentBounds.height - insets.bottom) {
                    int delta = currBounds.y + currBounds.height - (parentBounds.height - insets.bottom);
                    int temp3 = curr + 1;
                    while (temp3 < comps.length) {
                        comps[temp3].setVisible(false);
                        ++temp3;
                    }
                    done = false;
                    temp3 = curr;
                    while (!done && temp3 >= origCurr) {
                        if (comps[temp3] instanceof DSplitterBar) {
                            Point p = comps[temp3].getLocation();
                            p.y -= delta;
                            comps[temp3].setLocation(p);
                        } else {
                            done = comps[temp3].isVisible();
                        }
                        --temp3;
                    }
                }
                curr = origCurr;
                temp = curr - 1;
                while (temp > -1 && !comps[temp].isVisible()) {
                    comps[temp].setVisible(true);
                    --temp;
                }
                break block50;
            }
            if (currBounds.x < this.originalBounds.x) {
                boolean done = false;
                int temp = curr - 1;
                while (!done && temp > -1) {
                    if (comps[temp] instanceof DSplitterBar) {
                        Rectangle r = comps[temp].getBounds();
                        if (currBounds.x <= r.x + r.width) {
                            comps[temp].setLocation(currBounds.x - r.width, r.y);
                            int c = curr - 1;
                            while (c > temp) {
                                comps[c].setVisible(false);
                                --c;
                            }
                            curr = temp;
                            currBounds = comps[temp].getBounds();
                        } else {
                            done = true;
                        }
                    }
                    --temp;
                }
                if (currBounds.x <= insets.left) {
                    int delta = currBounds.x - insets.left;
                    int temp4 = curr - 1;
                    while (temp4 > -1) {
                        comps[temp4].setVisible(false);
                        --temp4;
                    }
                    done = false;
                    temp4 = curr;
                    while (!done && temp4 <= origCurr) {
                        if (comps[temp4] instanceof DSplitterBar) {
                            Point p = comps[temp4].getLocation();
                            p.x -= delta;
                            comps[temp4].setLocation(p);
                        } else {
                            done = comps[temp4].isVisible();
                        }
                        ++temp4;
                    }
                }
                curr = origCurr;
                temp = curr + 1;
                while (temp < comps.length && !comps[temp].isVisible()) {
                    comps[temp].setVisible(true);
                    ++temp;
                }
            } else if (currBounds.x > this.originalBounds.x) {
                boolean done = false;
                int temp = curr + 1;
                while (!done && temp < comps.length) {
                    if (comps[temp] instanceof DSplitterBar) {
                        Rectangle r = comps[temp].getBounds();
                        if (currBounds.x + currBounds.width >= r.x) {
                            comps[temp].setLocation(currBounds.x + currBounds.width, r.y);
                            int c = curr + 1;
                            while (c < temp) {
                                comps[c].setVisible(false);
                                ++c;
                            }
                            curr = temp;
                            currBounds = comps[temp].getBounds();
                        } else {
                            done = true;
                        }
                    }
                    ++temp;
                }
                if (currBounds.x + currBounds.width >= parentBounds.width - insets.right) {
                    int delta = currBounds.x + currBounds.width - (parentBounds.width - insets.right);
                    int temp5 = curr + 1;
                    while (temp5 < comps.length) {
                        comps[temp5].setVisible(false);
                        ++temp5;
                    }
                    done = false;
                    temp5 = curr;
                    while (!done && temp5 >= origCurr) {
                        if (comps[temp5] instanceof DSplitterBar) {
                            Point p = comps[temp5].getLocation();
                            p.x -= delta;
                            comps[temp5].setLocation(p);
                        } else {
                            done = comps[temp5].isVisible();
                        }
                        --temp5;
                    }
                }
                curr = origCurr;
                temp = curr - 1;
                while (temp > -1 && !comps[temp].isVisible()) {
                    comps[temp].setVisible(true);
                    --temp;
                }
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    void mouseDrag(MouseEvent e) {
        if (SplitterLayout.dragee == null) {
            SplitterLayout.dragee = this;
        } else if (SplitterLayout.dragee != this) {
            return;
        }
        Container c = this.getParent();
        Point fl = c.getLocationOnScreen();
        while (c.getParent() != null) {
            c = c.getParent();
        }
        if (!this.alreadyDrawn) {
            this.originalBounds = this.getBounds();
            this.wBar = new Window((Frame)c);
            this.wBar.setBackground(this.getBackground().darker());
        }
        Container cp = this.getParent();
        Dimension parentDim = cp.getSize();
        Point l = this.getLocationOnScreen();
        Insets insets = cp.getInsets();
        if (this.orientation == 0) {
            parentDim.width -= insets.right + insets.left;
        } else {
            parentDim.height -= insets.top + insets.bottom;
        }
        Rectangle r = this.getBounds();
        int x = l.x + (this.orientation == 1 ? e.getX() : 0);
        int y = l.y + (this.orientation == 0 ? e.getY() : 0);
        if (x < fl.x + insets.left) {
            x = fl.x + insets.left;
        } else if (this.orientation == 1 && x > fl.x + parentDim.width - r.width) {
            x = fl.x + parentDim.width - r.width;
        }
        if (y < fl.y + insets.top) {
            y = fl.y + insets.top;
        } else if (this.orientation == 0 && y > fl.y + parentDim.height - r.height) {
            y = fl.y + parentDim.height - r.height;
        }
        this.wBar.setBounds(x, y, this.orientation == 1 ? 3 : parentDim.width, this.orientation == 0 ? 3 : parentDim.height);
        if (!this.alreadyDrawn) {
            this.wBar.setVisible(true);
            this.alreadyDrawn = true;
        }
    }

    void mouseEnter(MouseEvent e) {
        if (SplitterLayout.dragee != null) {
            return;
        }
        this.setCursor(this.orientation == 0 ? VERT_CURSOR : HORIZ_CURSOR);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void mouseExit(MouseEvent e) {
        if (SplitterLayout.dragee != null) {
            return;
        }
        this.setCursor(DEF_CURSOR);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void mouseRelease(MouseEvent e) {
        if (this.alreadyDrawn) {
            if (SplitterLayout.dragee != this) {
                return;
            }
            SplitterLayout.dragee = null;
            this.wBar.setVisible(false);
            this.wBar.dispose();
            this.wBar = null;
            this.alreadyDrawn = false;
            Rectangle r = this.getBounds();
            r.x = r.x + (this.orientation == 1 ? e.getX() : 0);
            r.y = r.y + (this.orientation == 0 ? e.getY() : 0);
            this.setLocation(r.x, r.y);
            this.setCursor(DEF_CURSOR);
            this.checkOtherComponents();
            this.invalidate();
            this.getParent().validate();
            SplitterLayout.dragee = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getBackground());
        Component[] c = this.getComponents();
        if (c != null && c.length > 0) {
            int i = 0;
            while (i < c.length) {
                if (c[i] instanceof DSplitterSpace) {
                    Rectangle r = c[i].getBounds();
                    if (this.orientation == 0) {
                        g.fill3DRect(r.x + 2, r.y + r.height / 2 - 1, r.width - 5, 3, true);
                    } else {
                        g.fill3DRect(r.x + r.width / 2 - 1, r.y + 2, 3, r.y + r.height - 5, true);
                    }
                }
                ++i;
            }
        } else {
            Rectangle r = this.getBounds();
            if (this.orientation == 0) {
                g.fill3DRect(2, r.height / 2 - 1, r.width - 5, 3, true);
            } else {
                g.fill3DRect(r.width / 2 - 1, 2, 3, r.height - 5, true);
            }
        }
    }

    void setOrientation(int o) {
        this.orientation = o;
    }

    public void swapOrientation() {
        this.setOrientation(this.getOrientation() == 1 ? 0 : 1);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void setTooltip(String s) {
    }
}

