/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.split;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import org.catacomb.druid.swing.split.DSplitterBar;

public class SplitterLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected static DSplitterBar dragee = null;
    private int lastW = -1;
    private int lastH = -1;
    private boolean newComponentAdded = false;
    private Hashtable<Component, Object> relations = null;
    private int fieldOrientation = 0;

    public SplitterLayout() {
        this(0);
    }

    public SplitterLayout(int orientation) {
        this.setOrientation(orientation);
        this.relations = new Hashtable();
    }

    @Override
    public final void addLayoutComponent(Component comp, Object cin) {
        Object constraints = cin;
        if (constraints == null) {
            constraints = "1";
        }
        if (constraints instanceof Integer) {
            this.relations.put(comp, constraints);
            this.newComponentAdded = true;
        } else {
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    @Override
    public final void addLayoutComponent(String name, Component comp) {
        this.newComponentAdded = true;
        if (comp instanceof DSplitterBar) {
            ((DSplitterBar)comp).setOrientation(this.getOrientation());
        } else {
            if (name == null) {
                name = "1";
            }
            try {
                this.relations.put(comp, Integer.decode(name));
            }
            catch (NumberFormatException e) {
                this.relations.put(comp, new Integer(1));
            }
        }
    }

    public final Dimension checkLayoutSize(Container target, boolean getPrefSize) {
        Dimension dim = new Dimension(0, 0);
        Component[] c = target.getComponents();
        int i = 0;
        while (i < c.length) {
            if (c[i].isVisible()) {
                Dimension d = getPrefSize || c[i] instanceof DSplitterBar ? c[i].getPreferredSize() : c[i].getMinimumSize();
                if (this.getOrientation() == 0) {
                    dim.width = Math.max(d.width, dim.width);
                    dim.height += d.height;
                } else {
                    dim.height = Math.max(d.height, dim.height);
                    dim.width += d.width;
                }
            }
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public final float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public final float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public int getOrientation() {
        return this.fieldOrientation;
    }

    @Override
    public final void invalidateLayout(Container target) {
    }

    @Override
    public final void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension dim = target.getSize();
        int top = insets.top;
        int bottom = dim.height - insets.bottom;
        int left = insets.left;
        int right = dim.width - insets.right;
        boolean reScaleW = false;
        boolean reScaleH = false;
        float scaleW = 0.0f;
        float scaleH = 0.0f;
        if (this.lastW == -1) {
            this.lastW = dim.width;
            this.lastH = dim.height;
        } else {
            if (this.lastW != dim.width) {
                reScaleW = true;
                scaleW = (float)dim.width / (float)this.lastW;
                this.lastW = dim.width;
            }
            if (this.lastH != dim.height) {
                reScaleH = true;
                scaleH = (float)dim.height / (float)this.lastH;
                this.lastH = dim.height;
            }
        }
        dim.width = right - left;
        dim.height = bottom - top;
        int relativeSize = 0;
        int numRelatives = 0;
        Component[] c = target.getComponents();
        Object[] pSize = new Object[c.length];
        int orientation = this.getOrientation();
        int i = 0;
        while (i < c.length) {
            if (c[i].isVisible()) {
                if (c[i] instanceof DSplitterBar) {
                    Point p;
                    ((DSplitterBar)c[i]).setOrientation(orientation);
                    pSize[i] = c[i].getPreferredSize();
                    if (orientation == 0) {
                        dim.height -= ((Dimension)pSize[i]).height;
                        if (reScaleH) {
                            p = c[i].getLocation();
                            c[i].setLocation(p.x, (int)((float)p.y * scaleH));
                        }
                    } else {
                        dim.width -= ((Dimension)pSize[i]).width;
                        if (reScaleW) {
                            p = c[i].getLocation();
                            c[i].setLocation((int)((float)p.x * scaleW), p.y);
                        }
                    }
                } else {
                    pSize[i] = this.relations.get(c[i]);
                    relativeSize += ((Integer)pSize[i]).intValue();
                    ++numRelatives;
                }
            }
            ++i;
        }
        i = 0;
        while (i < c.length) {
            if (c[i].isVisible()) {
                Rectangle r = c[i].getBounds();
                if (c[i] instanceof DSplitterBar) {
                    if (orientation == 0) {
                        if (r.x != left || r.y != top || r.width != dim.width || r.height != ((Dimension)pSize[i]).height) {
                            c[i].setBounds(left, top, dim.width, ((Dimension)pSize[i]).height);
                        }
                        top += ((Dimension)pSize[i]).height;
                    } else {
                        if (r.x != left || r.y != top || r.height != dim.height || r.width != ((Dimension)pSize[i]).width) {
                            c[i].setBounds(left, top, ((Dimension)pSize[i]).width, dim.height);
                        }
                        left += ((Dimension)pSize[i]).width;
                    }
                } else if (i == c.length - 1) {
                    if (orientation == 0) {
                        if (r.x != left || r.y != top || r.width != dim.width || r.height != bottom - top) {
                            c[i].setBounds(left, top, dim.width, bottom - top);
                        }
                    } else if (r.x != left || r.y != top || r.width != right - left || r.height != dim.height) {
                        c[i].setBounds(left, top, right - left, dim.height);
                    }
                } else {
                    Point p = c[i + 1].getLocation();
                    if (!this.newComponentAdded && c[i + 1] instanceof DSplitterBar && (p.x != 0 || p.y != 0)) {
                        if (orientation == 0) {
                            if (r.x != left || r.y != top || r.width != dim.width || r.height != p.y - top) {
                                c[i].setBounds(left, top, dim.width, p.y - top);
                            }
                            top = p.y;
                        } else {
                            if (r.x != left || r.y != top || r.width != p.x - left || r.height != dim.height) {
                                c[i].setBounds(left, top, p.x - left, dim.height);
                            }
                            left = p.x;
                        }
                    } else {
                        int rel = (Integer)pSize[i];
                        float ratio = (float)rel / (float)relativeSize;
                        if (orientation == 0) {
                            if (r.x != left || r.y != top || r.width != dim.width || r.height != (int)(ratio *= (float)dim.height)) {
                                c[i].setBounds(left, top, dim.width, (int)ratio);
                            }
                            top += (int)ratio;
                        } else {
                            if (r.x != left || r.y != top || r.width != (int)(ratio *= (float)dim.width) || r.height != dim.height) {
                                c[i].setBounds(left, top, (int)ratio, dim.height);
                            }
                            left += (int)ratio;
                        }
                    }
                }
            }
            ++i;
        }
        this.newComponentAdded = false;
    }

    @Override
    public final Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final Dimension minimumLayoutSize(Container target) {
        return this.checkLayoutSize(target, true);
    }

    @Override
    public final Dimension preferredLayoutSize(Container target) {
        return this.checkLayoutSize(target, true);
    }

    @Override
    public final void removeLayoutComponent(Component comp) {
        this.relations.remove(comp);
        this.newComponentAdded = true;
    }

    public void setOrientation(int orientation) {
        this.fieldOrientation = orientation;
    }

    public void swapOrientation(Container container) {
        this.setOrientation(this.getOrientation() == 1 ? 0 : 1);
        Component[] comps = container.getComponents();
        int i = container.getComponentCount() - 1;
        while (i > -1) {
            if (comps[i] instanceof DSplitterBar) {
                ((DSplitterBar)comps[i]).swapOrientation();
            }
            comps[i].invalidate();
            --i;
        }
        this.newComponentAdded = true;
        container.validate();
    }

    public final String toString() {
        if (this.getOrientation() == 0) {
            return String.valueOf(this.getClass().getName()) + "[orientation=VERTICAL]";
        }
        return String.valueOf(this.getClass().getName()) + "[orientation=HORIZONTAL]";
    }
}

