/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.util.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.catacomb.druid.util.tree.ArrayListNode;
import org.catacomb.interlish.structure.Related;
import org.catacomb.interlish.structure.Relationship;

public class RelationNode
extends ArrayListNode {
    public Related peer;
    String[] types;
    RelationNode[] targets;
    HashMap<Related, RelationNode> childPeerHM;
    HashMap<String, RelationNode> parentHM;

    public RelationNode(Object parent, Related pr) {
        super(parent, "anon");
        this.peer = pr;
    }

    public Related getPeer() {
        return this.peer;
    }

    public boolean samePeer(RelationNode rn) {
        return this.peer == rn.peer;
    }

    @Override
    public void clearChildren() {
        if (this.childPeerHM != null) {
            this.childPeerHM.clear();
        }
        super.clearChildren();
    }

    public RelationNode makeChildlessCopy() {
        RelationNode rn = new RelationNode(null, this.peer);
        return rn;
    }

    @Override
    public void addChild(ArrayListNode aln) {
        super.addChild(aln);
        if (aln instanceof RelationNode) {
            RelationNode rn = (RelationNode)aln;
            if (this.childPeerHM == null) {
                this.childPeerHM = new HashMap();
            }
            this.childPeerHM.put(rn.getPeer(), rn);
        }
    }

    public void removeChild(RelationNode rn) {
        super.removeChild(rn);
        this.childPeerHM.remove(rn.getPeer());
    }

    public RelationNode getPeerEquivalentChild(RelationNode rn) {
        RelationNode ret = null;
        Related tgtpeer = rn.getPeer();
        if (this.childPeerHM != null && this.childPeerHM.containsKey(tgtpeer)) {
            ret = this.childPeerHM.get(tgtpeer);
        }
        return ret;
    }

    public void resolve(HashMap<Related, RelationNode> peers, HashSet<String> relationTypes) {
        Relationship[] rs = this.peer.getRelationships();
        this.parentHM = new HashMap();
        int nrel = 0;
        if (rs != null) {
            nrel = rs.length;
        }
        this.types = new String[nrel];
        this.targets = new RelationNode[nrel];
        int i = 0;
        while (i < nrel) {
            RelationNode rnode;
            String rel;
            this.types[i] = rel = rs[i].getType();
            Related tgt = rs[i].getTarget();
            this.targets[i] = rnode = peers.get(tgt);
            if (!this.parentHM.containsKey(rel)) {
                this.parentHM.put(rel, rnode);
            }
            if (!relationTypes.contains(rel)) {
                relationTypes.add(rel);
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.peer.toString();
    }

    public boolean fileAway(String rtyp) {
        boolean bfiled = false;
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].equals(rtyp)) {
                this.targets[i].addChild(this);
                bfiled = true;
            }
            ++i;
        }
        return bfiled;
    }

    public RelationNode getParent(String rel) {
        RelationNode ret = null;
        if (this.parentHM.containsKey(rel)) {
            ret = this.parentHM.get(rel);
        }
        this.parent = ret;
        return ret;
    }

    public void subtreeify(RelationNode parentRN, ArrayList rest, String rel) {
        System.out.println("XXX subtreeifying  " + parentRN + " " + rel);
        if (parentRN != null && this.parentHM.containsKey(rel)) {
            System.out.println("YYY moving down " + rel + " " + this);
            parentRN.removeChild(this);
            RelationNode target = this.parentHM.get(rel);
            this.insertUnder(parentRN, target, rest, rel);
        } else {
            RelationNode[] ach = this.children.toArray(new RelationNode[0]);
            int i = 0;
            while (i < ach.length) {
                ach[i].subtreeify(this, rest, rel);
                ++i;
            }
        }
    }

    private void insertUnder(RelationNode parentRN, RelationNode bot, ArrayList rest, String rel) {
        RelationNode next;
        int nup = 0;
        RelationNode[] path = new RelationNode[6];
        path[nup++] = bot;
        RelationNode current = bot;
        while ((next = current.getParent(rel)) != null) {
            path[nup++] = next;
            current = next;
        }
        RelationNode branch = parentRN;
        int id = nup - 1;
        while (id > 0) {
            RelationNode req = branch.getPeerEquivalentChild(path[id]);
            if (req == null) break;
            branch = req;
            --id;
        }
        int i = id;
        while (i >= 0) {
            RelationNode dtr = path[i].makeChildlessCopy();
            branch.addChild(dtr);
            branch = dtr;
            rest.remove(path[i]);
            --i;
        }
        branch.addChild(this);
    }
}

