/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.base;

import java.util.ArrayList;
import org.catacomb.druid.xtext.base.ContainerBlock;
import org.catacomb.druid.xtext.base.DocDisplay;
import org.catacomb.druid.xtext.base.XTDoc;
import org.catacomb.druid.xtext.parse.TextSplitter;
import org.catacomb.interlish.structure.Producer;
import org.catacomb.interlish.structure.SelectionActor;
import org.catacomb.interlish.structure.Tree;
import org.catacomb.interlish.structure.TreeChangeReporter;
import org.catacomb.interlish.structure.TreeExplorer;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.interlish.structure.TreeProvider;
import org.catacomb.report.E;

public class DocStore
implements Producer,
TreeProvider,
Tree,
TreeNode,
SelectionActor {
    ArrayList<XTDoc> docs = new ArrayList();
    XTDoc dummyDoc;
    static int iti = 100;
    TreeExplorer treeExp;
    DocDisplay docDisplay;
    TreeChangeReporter tcReporter;

    public String toString() {
        return "pages";
    }

    public void setDocDisplay(DocDisplay dd) {
        this.docDisplay = dd;
    }

    public XTDoc getDummyDoc(String txt) {
        if (this.dummyDoc == null) {
            TextSplitter ts = new TextSplitter(txt);
            ContainerBlock rootBlock = ts.makeBlock();
            this.dummyDoc = new XTDoc(this, "example", rootBlock);
            this.docs.add(this.dummyDoc);
            this.updateTree();
        }
        return this.dummyDoc;
    }

    public XTDoc getImportDoc(String txt, String name) {
        TextSplitter ts = new TextSplitter(txt);
        ContainerBlock rootBlock = ts.makeBlock();
        XTDoc xtd = new XTDoc(this, name, rootBlock);
        this.docs.add(xtd);
        this.updateTree();
        return xtd;
    }

    public XTDoc nextTextDoc() {
        ContainerBlock rb = ContainerBlock.newEmptyText();
        String title = "source_" + ++iti;
        XTDoc xtd = new XTDoc(this, title, rb);
        this.docs.add(xtd);
        this.updateTree();
        return xtd;
    }

    public void updateTree() {
        if (this.tcReporter != null) {
            E.info("NB should use tcReporter");
        }
        if (this.treeExp != null) {
            this.treeExp.treeModified();
            Object[] oa = new Object[]{this};
            this.treeExp.showNewItem(oa);
        }
    }

    @Override
    public void setTreeExplorer(TreeExplorer treeex) {
        this.treeExp = treeex;
        this.treeExp.setTree(this);
        this.treeExp.setSelectionActor(this);
        this.updateTree();
    }

    @Override
    public void setTreeChangeReporter(TreeChangeReporter tcr) {
        this.tcReporter = tcr;
    }

    @Override
    public Object getParent() {
        return null;
    }

    @Override
    public TreeNode getRoot() {
        return this;
    }

    @Override
    public int getRootPolicy() {
        return 1;
    }

    @Override
    public int getChildCount() {
        return this.docs.size();
    }

    @Override
    public Object getChild(int index) {
        return this.docs.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.docs.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public XTDoc getDocByID(String s) {
        XTDoc ret = null;
        for (XTDoc xtd : this.docs) {
            if (!s.equals(xtd.toString())) continue;
            ret = xtd;
            break;
        }
        return ret;
    }

    @Override
    public void selectionAction(Object obj, String id) {
        if (obj instanceof XTDoc) {
            if (this.docDisplay != null) {
                this.docDisplay.showDoc((XTDoc)obj);
            }
        } else {
            E.info("unexpected type " + obj);
            XTDoc xtd = this.getDocByID(id);
            if (this.docDisplay != null) {
                this.docDisplay.showDoc(xtd);
            }
        }
    }

    public void pageDataChanged() {
        if (this.docDisplay != null) {
            this.docDisplay.repaintPageData();
        }
    }

    @Override
    public Object[] getObjectPath(String s, boolean b) {
        E.missing();
        return null;
    }
}

