/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.base;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import org.catacomb.druid.color.StandardPalette;
import org.catacomb.druid.xtext.base.Slot;
import org.catacomb.druid.xtext.canvas.FontStore;
import org.catacomb.interlish.content.BasicTouchTime;

public class Guise {
    public String id;
    public ArrayList<Slot> slots;
    String fontFamily = "serif";
    String fontSize = "12";
    String fontStyle = "plain";
    Color fontColor = Color.black;
    boolean bUnderline = false;
    BasicTouchTime touchTime;
    BasicTouchTime cacheTime;
    Font cachedFont;
    static int icolor = 0;

    public Guise() {
        this.slots = new ArrayList();
        this.cacheTime = new BasicTouchTime();
        this.touchTime = new BasicTouchTime();
    }

    public void setNextPaletteColor() {
        this.setFontColor(StandardPalette.getColor(icolor));
        ++icolor;
    }

    public void touch() {
        this.touchTime.now();
    }

    public Font getFont() {
        if (this.cachedFont == null || this.cacheTime.isBefore(this.touchTime)) {
            this.updateCache();
        }
        return this.cachedFont;
    }

    public Color getColor() {
        return this.fontColor;
    }

    private void updateCache() {
        this.cachedFont = FontStore.instance().getFont(this.fontFamily, this.fontStyle, this.fontSize);
        this.cacheTime.now();
    }

    public void setID(String s) {
        this.id = s;
    }

    public String getID() {
        return this.id;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color c) {
        if (this.fontColor == null) {
            this.fontColor = Color.black;
        }
        this.fontColor = c;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        this.touch();
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fs) {
        this.fontSize = fs;
        this.touch();
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.touch();
    }

    public void setBoldFont() {
        this.setFontStyle("bold");
        this.touch();
    }

    public void setColorBlack() {
        this.setFontColor(Color.black);
    }

    public void setUnderline(boolean b) {
        this.bUnderline = b;
    }

    public boolean underline() {
        return this.bUnderline;
    }

    public void setColorDarkGreen() {
        this.setFontColor(new Color(0, 160, 0));
    }
}

