/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.base;

import org.catacomb.druid.xtext.StandardGuises;
import org.catacomb.druid.xtext.base.Block;
import org.catacomb.druid.xtext.base.Guise;
import org.catacomb.druid.xtext.base.NewlineBlock;
import org.catacomb.druid.xtext.base.WordBlock;
import org.catacomb.druid.xtext.data.XType;
import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.report.E;

public abstract class TextBlock
extends Block {
    public String text;
    int nchar;
    int[] cachedLimits = new int[4];
    XType type;
    BasicTouchTime cacheTime = new BasicTouchTime();

    public TextBlock() {
    }

    public TextBlock(String s) {
        this();
        this.text = s;
    }

    public int[] getCachedPosition() {
        return this.cachedLimits;
    }

    public void setCachedPosition(int x, int y, int w, int h) {
        this.cachedLimits[0] = x;
        this.cachedLimits[1] = y;
        this.cachedLimits[2] = w;
        this.cachedLimits[3] = h;
    }

    public void setText(String s) {
        this.text = s;
        this.nchar = s.length();
    }

    public int textLength() {
        return this.nchar;
    }

    public String getText() {
        return this.text;
    }

    public String getExtendedText() {
        return this.text;
    }

    boolean isText() {
        return this.text != null;
    }

    public TextBlock nextTextBlock() {
        Block ret = null;
        Block b = this;
        while (b.hasNext()) {
            if (!((b = b.next()) instanceof TextBlock)) continue;
            ret = b;
            break;
        }
        return ret;
    }

    public TextBlock previousTextBlock() {
        Block ret = null;
        Block b = this;
        while (b.hasPrevious()) {
            if (!((b = b.previous()) instanceof TextBlock)) continue;
            ret = b;
            break;
        }
        return ret;
    }

    public WordBlock getNextWordBlock() {
        WordBlock ret = null;
        Block b = this;
        while (b.hasNext()) {
            if (!((b = b.next()) instanceof WordBlock)) continue;
            ret = (WordBlock)b;
            break;
        }
        return ret;
    }

    public WordBlock getPreviousWordBlock() {
        WordBlock ret = null;
        Block b = this;
        while (b.hasPrevious()) {
            if (!((b = b.previous()) instanceof WordBlock)) continue;
            ret = (WordBlock)b;
            break;
        }
        return ret;
    }

    public void insertCharacter(char c, int ipos) {
        if (ipos == this.nchar) {
            this.setText(String.valueOf(this.text) + c);
        } else if (ipos == 0) {
            this.setText(String.valueOf(c) + this.text);
        } else {
            this.setText(String.valueOf(this.text.substring(0, ipos)) + c + this.text.substring(ipos, this.nchar));
        }
    }

    public void newlineAfter() {
        NewlineBlock b = new NewlineBlock();
        b.setNext(this.next());
        this.setNext(b);
    }

    public void insertNewline(int pos) {
        this.insert(new NewlineBlock(), pos);
    }

    public abstract TextBlock makeCopy();

    public abstract boolean matches(TextBlock var1);

    public void insert(TextBlock b_middle, int caretPos) {
        String texta = this.text.substring(0, caretPos);
        String textb = this.text.substring(caretPos, this.nchar);
        TextBlock b_end = this.makeCopy();
        Block b_after = this.next();
        this.setText(texta);
        b_end.setText(textb);
        this.setNext(b_middle);
        b_middle.setNext(b_end);
        b_end.setNext(b_after);
    }

    public void remove() {
        if (this.previous() == null) {
            E.warning("null previous?");
        } else {
            Block pr = this.previous();
            Block nx = this.next();
            if (pr instanceof TextBlock && nx instanceof TextBlock) {
                TextBlock tpr = (TextBlock)pr;
                TextBlock tnx = (TextBlock)nx;
                if (tpr.matches(tnx)) {
                    tpr.append(tnx);
                } else {
                    E.warning("shouldnt get here? " + pr.getClass() + " " + nx.getClass());
                    this.previous().setNext(this.next());
                }
            }
        }
    }

    public void append(TextBlock tb) {
        Block bn = tb.next();
        this.setText(String.valueOf(this.text) + tb.getText());
        this.setNext(bn);
    }

    public void deleteCharBefore(int caretPos) {
        String tnew = String.valueOf(this.text.substring(0, caretPos - 1)) + this.text.substring(caretPos, this.nchar);
        this.setText(tnew);
    }

    public void setType(XType xt) {
        this.type = xt;
        this.notifyAppearanceChange();
    }

    public XType getType() {
        return this.type;
    }

    public Guise getGuise() {
        Guise ret = null;
        ret = this.type != null ? this.type.getGuise() : StandardGuises.getDefault();
        return ret;
    }
}

