/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.drawing.VectorIcon;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;

public class IconWrapper
extends FixedDrawingComponent {
    VectorIcon icon;
    double xRel;
    double yRel;
    double scale;

    public IconWrapper(VectorIcon vi, double x, double y, double scl) {
        this.icon = vi;
        this.xRel = x;
        this.yRel = y;
        this.scale = scl;
        if (this.icon == null) {
            E.warning("wrapped null icon");
        }
    }

    @Override
    public boolean isWrapper() {
        return true;
    }

    @Override
    public void instruct(Painter p, double cx, double cy, double pscl) {
        if (this.icon != null) {
            this.icon.instruct(p, cx + pscl * this.xRel, cy + pscl * this.yRel, pscl * this.scale);
        }
    }

    public VectorIcon getIcon() {
        return this.icon;
    }

    public double getXRel() {
        return this.xRel;
    }

    public double getYRel() {
        return this.yRel;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void applyToShape(Shape shp) {
        E.missing(" cant apply icon wrapper to shape");
        double rx = 0.2;
        double ry = 0.2;
        double[] xpts = new double[]{this.xRel - rx, this.xRel - rx, this.xRel + rx, this.xRel + rx};
        double[] ypts = new double[]{this.yRel - ry, this.yRel + ry, this.yRel + ry, this.yRel - ry};
        shp.setXpts(xpts);
        shp.setYpts(ypts);
    }
}

