/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Position;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.PickStore;
import org.catacomb.graph.gui.Pickable;
import org.catacomb.graph.gui.PickablePoint;
import org.catacomb.graph.gui.PickableRegion;

public class Builder {
    Painter painter;
    PickStore pickStore;
    int width;
    int height;

    public Builder(Painter p, PickStore ps) {
        this.painter = p;
        this.pickStore = ps;
    }

    public void setCanvasSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void clear() {
        this.pickStore.clear();
    }

    public void add3DPickablePoint(double x, double y, double z, PickablePoint pp) {
        double wx = this.painter.xProj(x, y, z);
        double wy = this.painter.yProj(x, y, z);
        pp.moveTo(wx, wy);
        int ix = this.painter.powx(wx);
        int iy = this.painter.powy(wy);
        this.pickStore.addPoint(pp, ix, iy);
    }

    public void addPoint(PickablePoint pp) {
        this.addPickablePoint(pp);
    }

    public void addPickablePoint(PickablePoint pp) {
        this.addPickablePoint(pp, pp.getPosition());
    }

    public void addPickablePoint(PickablePoint pp, Position pos) {
        int ix = this.painter.powx(pos.getX());
        int iy = this.painter.powy(pos.getY());
        this.pickStore.addPoint(pp, ix, iy);
        this.painter.fillPixelRectangle(ix, iy, pp.getColor(), pp.getSize());
    }

    public void addPickableRegion(PickableRegion pka) {
        this.pickStore.addPickableRegion(pka, this.painter.powx(pka.getXReference()), this.painter.powy(pka.getYReference()));
    }

    public void addPickableRegion(Pickable pbl, int x, int y, int w, int h) {
        this.pickStore.addPoint(pbl, x, y, x + w, y + h);
    }

    public void add2DPickableRegionOn3DPoint(Pickable pbl, double x, double y, double z, int dx, int dy, int w, int h) {
        double wx = this.painter.xProj(x, y, z);
        double wy = this.painter.yProj(x, y, z);
        int ix = this.painter.powx(wx);
        int iy = this.painter.powy(wy);
        this.addPickableRegion(pbl, ix + dx, iy + dy, w, h);
    }
}

