/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

final class ClickZoomHandler
extends MouseHandler {
    private int xc;
    private int yc;
    double xfac = 1.0;
    double yfac = 1.0;
    static final int NORMAL = 1;
    static final int IN = 2;
    static final int OUT = 3;
    static final int INOUT = 4;
    int actionMode;
    boolean dragging = false;

    @Override
    public void activate() {
        this.actionMode = 1;
        super.activate();
    }

    public void activateInOut() {
        this.activate();
        this.actionMode = 4;
    }

    public void activateOut() {
        this.activate();
        this.actionMode = 3;
    }

    public void activateIn() {
        this.activate();
        this.actionMode = 2;
    }

    @Override
    public void init(Mouse m) {
        this.dragging = false;
        this.xc = m.getX();
        this.yc = m.getY();
        double zfac = 1.0;
        this.xfac = 1.0;
        this.yfac = 1.0;
        if (this.actionMode == 2) {
            zfac = 0.7;
            this.setClaimIn();
        } else if (this.actionMode == 3) {
            zfac = 1.4285714285714286;
            this.setClaimIn();
        } else if (this.actionMode == 4) {
            zfac = 1.0;
            if (m.leftButton()) {
                zfac = 0.7;
            } else if (m.rightButton()) {
                zfac = 1.4285714285714286;
            }
            this.setClaimIn();
        } else if (m.leftButton()) {
            zfac = 0.7;
        } else if (m.rightButton()) {
            zfac = 1.4285714285714286;
        } else {
            this.setClaimOut();
        }
        if (this.xc > 30) {
            this.xfac = zfac;
        }
        if (this.yc < m.getCanvasHeight() - 30) {
            this.yfac = zfac;
        }
    }

    @Override
    public void advance(Mouse m) {
        int dy;
        int dx;
        if (this.actionMode == 1 && (dx = m.getX() - this.xc) * dx + (dy = m.getY() - this.yc) * dy > 100) {
            this.setClaimOut();
        }
    }

    @Override
    public void release(Mouse m) {
        this.setClaimIn();
    }

    @Override
    public void applyOnDown(Mouse m) {
        m.initializeZoom(this.xc, this.yc);
    }

    @Override
    public void applyOnDrag(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        double rz = 100.0;
        double zx = Math.exp((double)(-(x - this.xc)) / rz);
        double zy = Math.exp((double)(y - this.yc) / rz);
        if (Math.abs(x - this.xc) * Math.abs(y - this.yc) > 5) {
            this.dragging = true;
        }
        m.dragZoom(zx, zy, this.xc, this.yc);
        this.setFullRepaint();
    }

    @Override
    public void applyOnRelease(Mouse m) {
        if (!this.dragging) {
            m.zoom(this.xfac, this.yfac, this.xc, this.yc);
        }
        m.restoreAA();
    }
}

