/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.util.ArrayList;
import org.catacomb.interlish.structure.IDable;
import org.catacomb.util.StringUtil;

public class DataView
implements IDable {
    public String id;
    public String abscissa;
    public String[] ordinates;
    public String multiOrdinate;
    public int[] multiIndexes;
    public double xMin;
    public double xMax;
    public double yMin;
    public double yMax;
    public static final int XY = 1;
    public static final int MOVIE = 2;
    public static final int EVTSEQ = 3;
    public int style;
    public String itemPath;

    public DataView() {
        this.style = 1;
    }

    public DataView(String s) {
        this.id = s;
        this.style = 1;
    }

    public DataView makeCopy() {
        DataView dv = new DataView(this.id);
        dv.setAbscissa(this.abscissa);
        dv.setOrdinates(StringUtil.copyArray(this.ordinates));
        dv.setMultiOrdinate(this.multiOrdinate);
        dv.setMultiIndexes(this.multiIndexes);
        dv.setXRange(this.xMin, this.xMax);
        dv.setYRange(this.yMin, this.yMax);
        dv.itemPath = this.itemPath;
        dv.style = this.style;
        return dv;
    }

    @Override
    public void setID(String s) {
        this.id = s;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public boolean isMovie() {
        return this.style == 2;
    }

    public boolean isXY() {
        return this.style == 1;
    }

    public boolean isEventSequence() {
        return this.style == 3;
    }

    public void setMoviePath(String s) {
        this.style = 2;
        this.itemPath = s;
    }

    public void setEventSequencePath(String s) {
        this.style = 3;
        this.itemPath = s;
    }

    public String getItemPath() {
        return this.itemPath;
    }

    public String getMoviePath() {
        return this.itemPath;
    }

    public void setAbscissa(String a) {
        this.abscissa = a;
    }

    public String getAbscissa() {
        return this.abscissa;
    }

    public void setOrdinates(String[] sa) {
        this.ordinates = sa;
    }

    public void setOrdinates(ArrayList<String> als) {
        this.ordinates = als.toArray(new String[0]);
    }

    public String[] getOrdinates() {
        return this.ordinates;
    }

    public void setXRange(double[] da) {
        this.setXRange(da[0], da[1]);
    }

    public void setYRange(double[] da) {
        this.setYRange(da[0], da[1]);
    }

    public void setXRange(double d, double e) {
        this.xMin = d;
        this.xMax = e;
    }

    public void setYRange(double d, double e) {
        this.yMin = d;
        this.yMax = e;
    }

    public boolean hasLimits() {
        return this.xMax > this.xMin && this.yMax > this.yMin;
    }

    public double[] getXYXYLimits() {
        double[] d = new double[]{this.xMin, this.yMin, this.xMax, this.yMax};
        return d;
    }

    public String getMultiOrdinate() {
        return this.multiOrdinate;
    }

    public void setMultiOrdinate(String s) {
        this.multiOrdinate = s;
    }

    public void clearMultiOrdinate() {
        this.multiOrdinate = null;
    }

    public void setMultiIndexes(int[] ia) {
        this.multiIndexes = ia;
    }

    public int[] getMultiIndexes() {
        return this.multiIndexes;
    }

    public void setAllMultiIndexes() {
        this.multiIndexes = null;
    }

    public void setNoneMultiIndexes() {
        this.multiIndexes = new int[0];
    }
}

