/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BasicStroke;
import org.catacomb.report.E;

public class DisplayStrokes {
    String[] styleNames;
    int nsn;
    double[] widths;
    int nw;
    BasicStroke[][] strokes;

    public DisplayStrokes(String[] sn, double[] w) {
        this.styleNames = sn;
        this.widths = w;
        this.nsn = this.styleNames.length;
        this.nw = this.widths.length;
        this.strokes = new BasicStroke[this.nsn][this.nw];
    }

    public BasicStroke getStroke(int ilin, int iwin) {
        BasicStroke ret;
        int il = ilin;
        int iw = iwin;
        if (il >= this.nsn) {
            il = this.nsn - 1;
        }
        if (iw >= this.nw) {
            iw = this.nw - 1;
        }
        if ((ret = this.strokes[il][iw]) == null) {
            this.strokes[il][iw] = ret = this.makeStroke(this.styleNames[il], this.widths[iw]);
        }
        return ret;
    }

    private BasicStroke makeStroke(String snm, double w) {
        float fw = (float)w;
        BasicStroke ret = null;
        if (snm.equals("solid")) {
            ret = new BasicStroke(fw);
        } else if (snm.equals("dotted")) {
            float[] dashes = new float[]{2.0f, 2.0f, 2.0f, 2.0f};
            ret = new BasicStroke(fw, 1, 2, 10.0f, dashes, 0.0f);
        } else if (snm.equals("short dash")) {
            float[] dashes = new float[]{6.0f, 6.0f, 6.0f, 6.0f};
            ret = new BasicStroke(fw, 0, 2, 10.0f, dashes, 0.0f);
        } else if (snm.equals("long dash")) {
            float[] dashes = new float[]{8.0f, 4.0f, 8.0f, 4.0f};
            ret = new BasicStroke(fw, 0, 2, 10.0f, dashes, 0.0f);
        } else if (snm.equals("dot-dash")) {
            float[] dashes = new float[]{2.0f, 2.0f, 8.0f, 2.0f};
            ret = new BasicStroke(fw, 1, 2, 10.0f, dashes, 0.0f);
        } else {
            E.warning("unrecognized line stype " + snm);
            ret = new BasicStroke(fw);
        }
        return ret;
    }
}

