/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.util.ArrayList;
import org.catacomb.graph.gui.DisplayStyleSet;
import org.catacomb.interlish.content.ColorTable;
import org.catacomb.interlish.content.KeyedList;

public class DisplayStylesData {
    static DisplayStylesData instance;
    KeyedList<ColorTable> colorTables = new KeyedList(ColorTable.class);
    KeyedList<DisplayStyleSet> styleSets = new KeyedList(DisplayStyleSet.class);

    public static DisplayStylesData getData() {
        if (instance == null) {
            instance = new DisplayStylesData();
        }
        return instance;
    }

    public DisplayStylesData() {
        this.addColorTable(new ColorTable("default"));
    }

    public DisplayStyleSet getStyleSet(String s) {
        return this.styleSets.getOrMake(s);
    }

    public ArrayList<DisplayStyleSet> getStyleSets() {
        return this.styleSets.getItems();
    }

    public ArrayList<ColorTable> getColorTables() {
        return this.colorTables.getItems();
    }

    public ColorTable getFirstColorTable() {
        return this.colorTables.getFirst();
    }

    public ColorTable getSetColorTable(String s) {
        DisplayStyleSet dss = this.getStyleSet(s);
        ColorTable ct = dss.getColorTable();
        if (ct == null) {
            ct = this.getColorTable(dss.getColorTableName());
            dss.setColorTable(ct);
        }
        return ct;
    }

    public ColorTable getColorTable(String s) {
        return this.colorTables.getOrMake(s);
    }

    private void addColorTable(ColorTable ct) {
        this.colorTables.addItem(ct);
    }
}

