/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

final class PanHandler
extends MouseHandler {
    private int xc;
    private int yc;
    static final int NORMAL = 0;
    static final int SIMPLE = 1;
    int actionMode = 0;

    @Override
    public void init(Mouse m) {
        this.xc = m.getX();
        this.yc = m.getY();
        if (this.actionMode == 1) {
            if (m.leftButton()) {
                this.setClaimIn();
            } else {
                this.setClaimOut();
            }
        } else if (m.leftButton()) {
            this.setClaimOut();
        } else if (!m.rightButton()) {
            this.setClaimOut();
        }
    }

    @Override
    public void activate() {
        this.actionMode = 0;
        super.activate();
    }

    public void simpleActivate() {
        this.activate();
        this.actionMode = 1;
    }

    @Override
    public void advance(Mouse m) {
        int dy;
        int dx = m.getX() - this.xc;
        if (dx * dx + (dy = m.getY() - this.yc) * dy > 100) {
            this.setClaimIn();
        }
    }

    @Override
    public void applyOnDrag(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        m.trialPan(this.xc, this.yc, x, y);
        this.setFullRepaint();
    }

    @Override
    public void applyOnRelease(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        m.permanentPan(this.xc, this.yc, x, y);
        m.restoreAA();
    }
}

