/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class RolloverEffect
extends MouseAdapter {
    JComponent button;
    int inormal;
    int iactive;
    Border normalBorder;
    Border activeBorder;
    public static final int NONE = 0;
    public static final int ETCHED_DOWN = 1;
    public static final int ETCHED_UP = 2;
    public static final int RAISED = 2;
    Color bgColor;
    int pL;
    int pR;
    int pT;
    int pB;
    private boolean hasPadding = false;

    public RolloverEffect(JComponent buttonIn) {
        this(buttonIn, 1, 2);
    }

    public RolloverEffect(JComponent buttonIn, int norm, int active) {
        this.bgColor = buttonIn.getBackground();
        this.inormal = norm;
        this.iactive = active;
        this.button = buttonIn;
        this.makeBorders();
        if (this.button instanceof AbstractButton) {
            ((AbstractButton)this.button).setBorderPainted(true);
        } else if (this.button instanceof JMenu) {
            ((JMenu)this.button).setBorderPainted(true);
        } else if (this.button instanceof JCheckBox) {
            ((JCheckBox)this.button).setBorderPainted(true);
        } else {
            boolean cfr_ignored_0 = this.button instanceof JPanel;
        }
        this.mouseExited(null);
    }

    public void setPadding(int p) {
        this.setPadding(p, p, p, p);
    }

    public void setPadding(int pl, int pr, int pt, int pb) {
        this.pL = pl;
        this.pR = pr;
        this.pT = pt;
        this.pB = pb;
        this.hasPadding = true;
        this.makeBorders();
        this.mouseExited(null);
    }

    public void setBg(Color c) {
        this.bgColor = c;
        this.makeBorders();
        this.mouseExited(null);
    }

    public void makeBorders() {
        this.normalBorder = this.makeBorder(this.inormal);
        this.activeBorder = this.makeBorder(this.iactive);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.button.setBorder(this.activeBorder);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.button.setBorder(this.normalBorder);
    }

    private Border makeBorder(int type) {
        Color c = this.bgColor;
        Color cbr = RolloverEffect.myBrighter(c);
        Color cdk = RolloverEffect.myDarker(c);
        Border ret = null;
        ret = type == 1 ? BorderFactory.createEtchedBorder(cbr, cdk) : (type == 2 ? BorderFactory.createEtchedBorder(cdk, cbr) : BorderFactory.createEmptyBorder(2, 2, 2, 2));
        if (this.hasPadding) {
            Border bdr = BorderFactory.createEmptyBorder(this.pT, this.pL, this.pB, this.pR);
            ret = BorderFactory.createCompoundBorder(ret, bdr);
        }
        return ret;
    }

    public static Color myBrighter(Color c) {
        return RolloverEffect.linMod(c, 35);
    }

    public static Color myDarker(Color c) {
        return RolloverEffect.linMod(c, -35);
    }

    public static Color linMod(Color c, int d) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        b += d;
        int n = (r += d) > 0 ? (r < 255 ? r : 255) : (r = 0);
        int n2 = g > 0 ? (g < 255 ? (g += d) : 255) : (g = 0);
        b = b > 0 ? (b < 255 ? b : 255) : 0;
        return new Color(r, g, b);
    }
}

