/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.icon.splash;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.catacomb.Root;
import org.catacomb.icon.splash.Splash;
import org.catacomb.report.E;

public class Splasher {
    static Splasher splasher;
    Splash splash;

    public static void showSplash(String confpath) {
        new Splasher(confpath);
    }

    public static void hideSplash() {
        if (splasher != null) {
            splasher.instanceHideSplash();
        }
    }

    public Splasher(String configPath) {
        String config = Splasher.getXMLResource(configPath);
        String att = Splasher.getAttribute("splashScreen", "src", config);
        if (att != null) {
            String pp = Splasher.parentPath(configPath);
            this.splash = new Splash(pp, att);
            this.splash.show();
        }
    }

    public void instanceHideSplash() {
        if (this.splash != null) {
            this.splash.hide();
        }
    }

    public static void main(String[] argv) {
        Splasher.showSplash(argv[0]);
    }

    public static String parentPath(String pth) {
        String separator = ".";
        int ils = pth.lastIndexOf(separator);
        String ret = null;
        ret = ils > 0 ? pth.substring(0, ils) : pth;
        return ret;
    }

    public static String getXMLResource(String pathin) {
        String path = pathin;
        String sret = null;
        if (path.endsWith(".xml") || path.indexOf(".") < 0) {
            E.warning("getXMLReousrce should have a dot path, not " + path);
        } else {
            path = String.valueOf(path.replaceAll("\\.", "/")) + ".xml";
        }
        try {
            String pref = "org/catacomb/";
            if (path.startsWith(pref)) {
                path = path.substring(pref.length(), path.length());
                InputStream fis = new Root().getClass().getResourceAsStream(path);
                sret = Splasher.readInputStream(fis);
            } else {
                InputStream fis = ClassLoader.getSystemResourceAsStream(path);
                sret = Splasher.readInputStream(fis);
            }
        }
        catch (Exception ex) {
            E.error("ResourceAccess - cant get " + path + " " + ex);
            ex.printStackTrace();
        }
        return sret;
    }

    private static String readInputStream(InputStream fis) throws NullPointerException, IOException {
        String sret = null;
        InputStreamReader insr = new InputStreamReader(fis);
        BufferedReader fr = new BufferedReader(insr);
        StringBuffer sb = new StringBuffer();
        while (fr.ready()) {
            sb.append(fr.readLine());
            sb.append("\n");
        }
        fr.close();
        sret = sb.toString();
        return sret;
    }

    private static String getAttribute(String enm, String atnm, String src) {
        String ret = null;
        String etxt = Splasher.getElementText(enm, src);
        if (etxt != null) {
            ret = Splasher.getAttribute(atnm, etxt);
        }
        return ret;
    }

    private static String getAttribute(String atnm, String src) {
        String ret = null;
        Pattern pat = Pattern.compile(String.valueOf(atnm) + "=\"(.*)\"");
        Matcher matcher = pat.matcher(src);
        if (matcher.find()) {
            ret = matcher.group(1);
        }
        return ret;
    }

    private static String getElementText(String enm, String src) {
        String ret = Splasher.getVerboseElementText(enm, src);
        if (ret == null) {
            ret = Splasher.getCompactElementText(enm, src);
        }
        return ret;
    }

    private static String getVerboseElementText(String enm, String src) {
        String ret = null;
        Pattern pat = Pattern.compile("<" + enm + ">(.*)</" + enm + ">");
        Matcher matcher = pat.matcher(src);
        if (matcher.find()) {
            ret = matcher.group(1);
        }
        return ret;
    }

    private static String getCompactElementText(String enm, String src) {
        String ret = null;
        Pattern pat = Pattern.compile("<" + enm + " (.*)/>");
        Matcher matcher = pat.matcher(src);
        if (matcher.find()) {
            ret = matcher.group(1);
        }
        return ret;
    }
}

