/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import org.catacomb.interlish.content.PrimitiveValue;

public class StringValue
extends PrimitiveValue {
    private String text;
    private int highlight;

    public StringValue() {
        this.text = null;
    }

    public StringValue(String s) {
        this.text = s;
    }

    public StringValue(String s, boolean b) {
        super(b);
        this.text = s;
    }

    public String toString() {
        return "StringValue: " + this.text;
    }

    public void silentSetString(String s) {
        this.text = s;
        this.logChange();
    }

    public String getString() {
        this.reportUse(this);
        return this.text;
    }

    public String getAsString() {
        this.reportUse(this);
        return this.text != null ? this.text : "";
    }

    public void clear() {
        this.silentSetString("");
    }

    public void set(String s) {
        this.reportableSetString(s, this);
    }

    public void reportableSetString(String s, Object src) {
        this.silentSetString(s);
        this.reportValueChange(src);
        this.reportUse(src);
    }

    public boolean hasNonTrivialValue() {
        return this.text != null && this.text.trim().length() > 0;
    }

    public void copyFrom(StringValue src) {
        this.silentSetString(src.getString());
    }

    public void append(String string) {
        this.reportableSetString(String.valueOf(this.text) + string, null);
    }

    public void highlightLine(int i) {
        this.highlight = i;
        this.reportValueChange("HIGHLIGHT");
    }

    public void clearHighlight() {
        this.highlight = -1;
    }

    public int getHighlight() {
        return this.highlight;
    }

    public void silentAppendLine(String txt) {
        if (this.text == null) {
            this.text = "";
        }
        if (this.text.length() != 0 && !this.text.endsWith("\n")) {
            this.text = String.valueOf(this.text) + "\n";
        }
        this.text = String.valueOf(this.text) + txt;
        this.text = String.valueOf(this.text) + "\n";
    }

    public String silentGetAsString() {
        return this.text != null ? this.text : "";
    }
}

